/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufUtil;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.SchemaType;

public class ByteBufSchema
extends AbstractSchema<ByteBuf> {
    private static final ByteBufSchema INSTANCE;
    private static final SchemaInfo SCHEMA_INFO;

    public static ByteBufSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(ByteBuf message) {
        if (message == null) {
            return null;
        }
        return ByteBufUtil.getBytes(message);
    }

    @Override
    public ByteBuf decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        return Unpooled.wrappedBuffer(bytes);
    }

    @Override
    public ByteBuf decode(ByteBuf byteBuf) {
        return byteBuf;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }

    static {
        SCHEMA_INFO = new SchemaInfoImpl().setName("ByteBuf").setType(SchemaType.BYTES).setSchema(new byte[0]);
        INSTANCE = new ByteBufSchema();
    }
}

