/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web.plugin.servlet;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletDefinition;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletDefinitions;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletMetadata;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdditionalServletUtils {
    private static final Logger log = LoggerFactory.getLogger(AdditionalServletUtils.class);
    public static final String ADDITIONAL_SERVLET_FILE = "additional_servlet.yml";

    public static AdditionalServletDefinition getAdditionalServletDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).extractionDirectory(narExtractionDirectory).build();){
            AdditionalServletDefinition additionalServletDefinition = AdditionalServletUtils.getAdditionalServletDefinition(ncl);
            return additionalServletDefinition;
        }
    }

    private static AdditionalServletDefinition getAdditionalServletDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(ADDITIONAL_SERVLET_FILE);
        return ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, AdditionalServletDefinition.class);
    }

    public static AdditionalServletDefinitions searchForServlets(String additionalServletDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(additionalServletDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for additional servlets in {}", (Object)path);
        AdditionalServletDefinitions servletDefinitions = new AdditionalServletDefinitions();
        if (!path.toFile().exists()) {
            log.warn("Pulsar additional servlets directory not found");
            return servletDefinitions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    AdditionalServletDefinition def = AdditionalServletUtils.getAdditionalServletDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found additional servlet from {} : {}", (Object)archive, (Object)def);
                    Preconditions.checkArgument(StringUtils.isNotBlank(def.getName()));
                    Preconditions.checkArgument(StringUtils.isNotBlank(def.getAdditionalServletClass()));
                    AdditionalServletMetadata metadata = new AdditionalServletMetadata();
                    metadata.setDefinition(def);
                    metadata.setArchivePath(archive);
                    servletDefinitions.servlets().put(def.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load additional servlet from {}. It is OK however if you want to use this additional servlet, please make sure you put the correct additional servlet NAR package in the additional servlets directory.", (Object)archive, (Object)t);
                }
            }
        }
        return servletDefinitions;
    }

    public static AdditionalServletWithClassLoader load(AdditionalServletMetadata metadata, String narExtractionDirectory) throws IOException {
        File narFile = metadata.getArchivePath().toAbsolutePath().toFile();
        NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(narFile).parentClassLoader(AdditionalServlet.class.getClassLoader()).extractionDirectory(narExtractionDirectory).build();
        AdditionalServletDefinition def = AdditionalServletUtils.getAdditionalServletDefinition(ncl);
        if (StringUtils.isBlank(def.getAdditionalServletClass())) {
            throw new IOException("Additional servlets `" + def.getName() + "` does NOT provide an additional servlets implementation");
        }
        try {
            Class<?> additionalServletClass = ncl.loadClass(def.getAdditionalServletClass());
            Object additionalServlet = additionalServletClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(additionalServlet instanceof AdditionalServlet)) {
                throw new IOException("Class " + def.getAdditionalServletClass() + " does not implement additional servlet interface");
            }
            AdditionalServlet servlet = (AdditionalServlet)additionalServlet;
            return new AdditionalServletWithClassLoader(servlet, ncl);
        }
        catch (Throwable t) {
            AdditionalServletUtils.rethrowIOException(t);
            return null;
        }
    }

    private static void rethrowIOException(Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new IOException(cause.getMessage(), cause);
    }

    private AdditionalServletUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

