/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.LoadReport;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.ServiceUnit;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.NamespaceIsolationPolicy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleResourceAllocationPolicies {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleResourceAllocationPolicies.class);
    private final PulsarService pulsar;

    public SimpleResourceAllocationPolicies(PulsarService pulsar) {
        this.pulsar = pulsar;
    }

    public boolean canAssign(ServiceUnit srvUnit, ResourceUnit rescrUnit, Map<ResourceUnit, LoadReport> loadReports) {
        return true;
    }

    private Optional<NamespaceIsolationPolicies> getIsolationPolicies(String clusterName) {
        try {
            return this.pulsar.getPulsarResources().getNamespaceResources().getIsolationPolicies().getIsolationDataPolicies(clusterName);
        }
        catch (Exception e) {
            LOG.warn("GetIsolationPolicies: Unable to get the namespaceIsolationPolicies", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean areIsolationPoliciesPresent(NamespaceName namespace) {
        try {
            Optional<NamespaceIsolationPolicies> policies = this.getIsolationPolicies(this.pulsar.getConfiguration().getClusterName());
            return policies.filter(isolationPolicies -> isolationPolicies.getPolicyByNamespace(namespace) != null).isPresent();
        }
        catch (Exception e) {
            LOG.warn("IsIsolationPoliciesPresent: Unable to get the namespaceIsolationPolicies", (Throwable)e);
            return false;
        }
    }

    private Optional<NamespaceIsolationPolicy> getNamespaceIsolationPolicy(NamespaceName namespace) {
        try {
            Optional<NamespaceIsolationPolicies> policies = this.getIsolationPolicies(this.pulsar.getConfiguration().getClusterName());
            return policies.map(isolationPolicies -> isolationPolicies.getPolicyByNamespace(namespace));
        }
        catch (Exception e) {
            LOG.warn("Unable to get the namespaceIsolationPolicies", (Throwable)e);
            return Optional.empty();
        }
    }

    public boolean isPrimaryBroker(NamespaceName namespace, String broker) {
        Optional<NamespaceIsolationPolicy> nsPolicy = this.getNamespaceIsolationPolicy(namespace);
        return nsPolicy.isPresent() && nsPolicy.get().isPrimaryBroker(broker);
    }

    public boolean isSecondaryBroker(NamespaceName namespace, String broker) {
        Optional<NamespaceIsolationPolicy> nsPolicy = this.getNamespaceIsolationPolicy(namespace);
        return nsPolicy.isPresent() && nsPolicy.get().isSecondaryBroker(broker);
    }

    public boolean isSharedBroker(String broker) {
        try {
            Optional<NamespaceIsolationPolicies> policies = this.getIsolationPolicies(this.pulsar.getConfiguration().getClusterName());
            return policies.map(isolationPolicies -> isolationPolicies.isSharedBroker(broker)).orElse(true);
        }
        catch (Exception e) {
            LOG.warn("isPrimaryForAnyNamespace", (Throwable)e);
            return false;
        }
    }

    public boolean shouldFailoverToSecondaries(NamespaceName namespace, int totalPrimaryCandidates) {
        Optional<NamespaceIsolationPolicy> nsPolicy = this.getNamespaceIsolationPolicy(namespace);
        return nsPolicy.isPresent() && nsPolicy.get().shouldFailover(totalPrimaryCandidates);
    }
}

