/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.kv;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.com.google.protobuf.ByteString;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.DeleteOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.IncrementOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.Op;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.PutOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.RangeOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.TxnOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.op.TxnOpBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.DeleteOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.IncrementOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.PutOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.RangeOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.options.RangeOptionBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.DeleteResult;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.IncrementResult;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.PutResult;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.RangeResult;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.result.TxnResult;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.mvcc.MVCCAsyncStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.Compare;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.IncrementResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.PutRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.PutResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RangeRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RangeResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RequestOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.ResponseHeader;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.RoutingHeader;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.TxnRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.rpc.TxnResponse;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.api.kv.TableStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.storage.impl.kv.TableStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreImpl
implements TableStore {
    private static final Logger log = LoggerFactory.getLogger(TableStoreImpl.class);
    private final MVCCAsyncStore<byte[], byte[]> store;

    public TableStoreImpl(MVCCAsyncStore<byte[], byte[]> store) {
        this.store = store;
    }

    @Override
    public CompletableFuture<RangeResponse> range(RangeRequest rangeReq) {
        if (log.isTraceEnabled()) {
            log.trace("Received range request {}", (Object)rangeReq);
        }
        return ((CompletableFuture)this.doRange(rangeReq).thenApply(result -> {
            try {
                RangeResponse rangeResp;
                RangeResponse rangeResponse = rangeResp = TableStoreUtils.processRangeResult(rangeReq.getHeader(), result);
                return rangeResponse;
            }
            finally {
                result.close();
            }
        })).exceptionally(cause -> {
            log.error("Failed to process range request {}", (Object)rangeReq, cause);
            return RangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.handleCause(cause)).setRoutingHeader(rangeReq.getHeader()).build()).build();
        });
    }

    private CompletableFuture<RangeResult<byte[], byte[]>> doRange(RangeRequest request) {
        RangeOp<byte[], byte[]> op = this.buildRangeOp(request.getHeader(), request);
        return this.store.range(op).whenComplete((rangeResult, throwable) -> op.close());
    }

    private RangeOp<byte[], byte[]> buildRangeOp(RoutingHeader header, RangeRequest request) {
        ByteString rKey = header.getRKey();
        ByteString lKey = request.getKey();
        ByteString lEndKey = request.getRangeEnd();
        byte[] storeKey = TableStoreUtils.newStoreKey(rKey, lKey);
        byte[] storeEndKey = null;
        if (null != lEndKey && lEndKey.size() > 0) {
            storeEndKey = TableStoreUtils.newStoreKey(rKey, lEndKey);
        }
        RangeOptionBuilder<byte[]> optionBuilder = this.store.getOpFactory().optionFactory().newRangeOption();
        if (request.getLimit() > 0L) {
            optionBuilder.limit(request.getLimit());
        }
        if (request.getMaxCreateRevision() > 0L) {
            optionBuilder.maxCreateRev(request.getMaxCreateRevision());
        }
        if (request.getMaxModRevision() > 0L) {
            optionBuilder.maxModRev(request.getMaxModRevision());
        }
        if (request.getMinCreateRevision() > 0L) {
            optionBuilder.minCreateRev(request.getMinCreateRevision());
        }
        if (request.getMinModRevision() > 0L) {
            optionBuilder.minModRev(request.getMinModRevision());
        }
        if (null != storeEndKey) {
            optionBuilder.endKey(storeEndKey);
        }
        return this.store.getOpFactory().newRange(storeKey, (RangeOption)optionBuilder.build());
    }

    @Override
    public CompletableFuture<PutResponse> put(PutRequest putReq) {
        return ((CompletableFuture)this.doPut(putReq).thenApply(result -> {
            try {
                PutResponse putResponse = TableStoreUtils.processPutResult(putReq.getHeader(), result);
                return putResponse;
            }
            finally {
                result.close();
            }
        })).exceptionally(cause -> {
            log.error("Failed to process put request {}", (Object)putReq, cause);
            return PutResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.handleCause(cause)).setRoutingHeader(putReq.getHeader()).build()).build();
        });
    }

    private CompletableFuture<PutResult<byte[], byte[]>> doPut(PutRequest request) {
        PutOp<byte[], byte[]> op = this.buildPutOp(request.getHeader(), request);
        return this.store.put(op).whenComplete((putResult, throwable) -> op.close());
    }

    private PutOp<byte[], byte[]> buildPutOp(RoutingHeader header, PutRequest request) {
        ByteString rKey = header.getRKey();
        ByteString lKey = request.getKey();
        byte[] storeKey = TableStoreUtils.newStoreKey(rKey, lKey);
        return this.store.getOpFactory().newPut(storeKey, request.getValue().toByteArray(), (PutOption)this.store.getOpFactory().optionFactory().newPutOption().prevKv(request.getPrevKv()).build());
    }

    @Override
    public CompletableFuture<IncrementResponse> incr(IncrementRequest incrementReq) {
        return ((CompletableFuture)this.doIncrement(incrementReq).thenApply(result -> {
            try {
                IncrementResponse incrementResponse = TableStoreUtils.processIncrementResult(incrementReq.getHeader(), result);
                return incrementResponse;
            }
            finally {
                result.close();
            }
        })).exceptionally(cause -> {
            log.error("Failed to process increment request {}", (Object)incrementReq, cause);
            return IncrementResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.handleCause(cause)).setRoutingHeader(incrementReq.getHeader()).build()).build();
        });
    }

    private CompletableFuture<IncrementResult<byte[], byte[]>> doIncrement(IncrementRequest request) {
        IncrementOp<byte[], byte[]> op = this.buildIncrementOp(request.getHeader(), request);
        return this.store.increment(op).whenComplete((incrementResult, throwable) -> op.close());
    }

    private IncrementOp<byte[], byte[]> buildIncrementOp(RoutingHeader header, IncrementRequest request) {
        ByteString rKey = header.getRKey();
        ByteString lKey = request.getKey();
        byte[] storeKey = TableStoreUtils.newStoreKey(rKey, lKey);
        return this.store.getOpFactory().newIncrement(storeKey, request.getAmount(), (IncrementOption)this.store.getOpFactory().optionFactory().newIncrementOption().getTotal(request.getGetTotal()).build());
    }

    @Override
    public CompletableFuture<DeleteRangeResponse> delete(DeleteRangeRequest deleteReq) {
        return ((CompletableFuture)this.doDelete(deleteReq).thenApply(result -> {
            try {
                DeleteRangeResponse deleteRangeResponse = TableStoreUtils.processDeleteResult(deleteReq.getHeader(), result);
                return deleteRangeResponse;
            }
            finally {
                result.close();
            }
        })).exceptionally(cause -> DeleteRangeResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.handleCause(cause)).setRoutingHeader(deleteReq.getHeader()).build()).build());
    }

    private CompletableFuture<DeleteResult<byte[], byte[]>> doDelete(DeleteRangeRequest request) {
        DeleteOp<byte[], byte[]> op = this.buildDeleteOp(request.getHeader(), request);
        return this.store.delete((byte[])op).whenComplete((deleteResult, throwable) -> op.close());
    }

    private DeleteOp<byte[], byte[]> buildDeleteOp(RoutingHeader header, DeleteRangeRequest request) {
        ByteString rKey = header.getRKey();
        ByteString lKey = request.getKey();
        ByteString lEndKey = request.getRangeEnd();
        byte[] storeKey = TableStoreUtils.newStoreKey(rKey, lKey);
        byte[] storeEndKey = null;
        if (null != lEndKey && lEndKey.size() > 0) {
            storeEndKey = TableStoreUtils.newStoreKey(rKey, lEndKey);
        }
        return this.store.getOpFactory().newDelete(storeKey, (DeleteOption)this.store.getOpFactory().optionFactory().newDeleteOption().prevKv(request.getPrevKv()).endKey(storeEndKey).build());
    }

    @Override
    public CompletableFuture<TxnResponse> txn(TxnRequest txnReq) {
        if (log.isTraceEnabled()) {
            log.trace("Received txn request : {}", (Object)txnReq);
        }
        return ((CompletableFuture)this.doTxn(txnReq).thenApply(txnResult -> {
            try {
                TxnResponse txnResponse = TableStoreUtils.processTxnResult(txnReq.getHeader(), txnResult);
                return txnResponse;
            }
            finally {
                txnResult.close();
            }
        })).exceptionally(cause -> TxnResponse.newBuilder().setHeader(ResponseHeader.newBuilder().setCode(TableStoreUtils.handleCause(cause)).setRoutingHeader(txnReq.getHeader()).build()).build());
    }

    private CompletableFuture<TxnResult<byte[], byte[]>> doTxn(TxnRequest request) {
        TxnOp<byte[], byte[]> op = this.buildTxnOp(request);
        return this.store.txn(op).whenComplete((txnResult, throwable) -> op.close());
    }

    private TxnOp<byte[], byte[]> buildTxnOp(TxnRequest request) {
        RoutingHeader header = request.getHeader();
        TxnOpBuilder<byte[], byte[]> txnBuilder = this.store.getOpFactory().newTxn();
        for (RequestOp requestOp : request.getSuccessList()) {
            txnBuilder.Then(this.buildTxnOp(header, requestOp));
        }
        for (RequestOp requestOp : request.getFailureList()) {
            txnBuilder.Else(this.buildTxnOp(header, requestOp));
        }
        for (Compare compare : request.getCompareList()) {
            txnBuilder.If(TableStoreUtils.fromProtoCompare(this.store.getOpFactory(), header, compare));
        }
        return txnBuilder.build();
    }

    private Op<byte[], byte[]> buildTxnOp(RoutingHeader header, RequestOp reqOp) {
        switch (reqOp.getRequestCase()) {
            case REQUEST_PUT: {
                return this.buildPutOp(header, reqOp.getRequestPut());
            }
            case REQUEST_DELETE_RANGE: {
                return this.buildDeleteOp(header, reqOp.getRequestDeleteRange());
            }
            case REQUEST_RANGE: {
                return this.buildRangeOp(header, reqOp.getRequestRange());
            }
        }
        throw new IllegalArgumentException("unknown request type in a transaction" + reqOp.getRequestCase());
    }
}

