/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.codahale.FastSnapshot;

public class FastTimer
extends Timer {
    private static final int HASH_SIZE = 3;
    private static final int TIME_WINDOW = 60;
    private static final long[][] BUCKET_SPEC_FINE = new long[][]{{100L, 100000L}, {90L, 1000000L}, {90L, 10000000L}, {9L, 1000000000L}};
    private static final long[][] BUCKET_SPEC_COARSE = new long[][]{{20L, 1000000000L}};
    private static final int BS_NUMBUCKETS = 0;
    private static final int BS_RESOLUTION = 1;
    private final long[][] bucketSpec;
    private final int numBuckets;
    private final long[] bucketBounds;
    private final int timeWindow;
    private final int startTime;
    private final AtomicLong[] counter;
    private final Object[] locks;
    private final int[] lastTime;
    private int lastTimeBucket = 0;
    private final int[][] meter;
    private final int[][] buckets;
    private final long[][] min;
    private final long[][] max;
    private final long[][] sum;

    public FastTimer() {
        this(60, Buckets.fine);
    }

    public FastTimer(int timeWindowSeconds, Buckets buckets) {
        super((Reservoir)new DummyReservoir());
        this.timeWindow = timeWindowSeconds + 2;
        switch (buckets) {
            case fine: {
                this.bucketSpec = BUCKET_SPEC_FINE;
                break;
            }
            case coarse: {
                this.bucketSpec = BUCKET_SPEC_COARSE;
                break;
            }
            default: {
                this.bucketSpec = null;
            }
        }
        int bucketCnt = 0;
        for (int i = 0; this.bucketSpec != null && i < this.bucketSpec.length; ++i) {
            bucketCnt = (int)((long)bucketCnt + this.bucketSpec[i][0]);
        }
        int n = this.numBuckets = bucketCnt > 0 ? bucketCnt + 1 : 0;
        if (this.numBuckets > 0) {
            this.bucketBounds = new long[this.bucketSpec.length];
            long bound = 0L;
            for (int i = 0; i < this.bucketSpec.length; ++i) {
                this.bucketBounds[i] = bound += this.bucketSpec[i][0] * this.bucketSpec[i][1];
            }
        } else {
            this.bucketBounds = null;
        }
        this.startTime = this.getTime();
        this.counter = new AtomicLong[3];
        for (int i = 0; i < this.counter.length; ++i) {
            this.counter[i] = new AtomicLong(0L);
        }
        this.meter = new int[3][this.timeWindow];
        this.buckets = this.numBuckets > 0 ? new int[this.numBuckets][this.timeWindow] : (int[][])null;
        this.sum = new long[3][this.timeWindow];
        this.min = new long[3][this.timeWindow];
        this.max = new long[3][this.timeWindow];
        this.lastTime = new int[3];
        this.locks = new Object[3];
        for (int h = 0; h < this.locks.length; ++h) {
            this.locks[h] = new Object();
        }
    }

    public int getNumberOfBuckets() {
        return this.numBuckets;
    }

    public int getBucket(long duration) {
        if (this.numBuckets == 0) {
            return -1;
        }
        int bucket = 0;
        long lowbound = 0L;
        for (int i = 0; i < this.bucketSpec.length; ++i) {
            if (duration <= this.bucketBounds[i]) {
                return bucket + (int)((duration - lowbound - 1L) / this.bucketSpec[i][1]);
            }
            bucket = (int)((long)bucket + this.bucketSpec[i][0]);
            lowbound = this.bucketBounds[i];
        }
        return this.numBuckets - 1;
    }

    public long getBucketBound(int b) {
        if (this.numBuckets == 0) {
            return -1L;
        }
        int bucket = 0;
        long lowbound = 0L;
        for (int i = 0; i < this.bucketSpec.length; ++i) {
            if ((long)b < (long)bucket + this.bucketSpec[i][0]) {
                return lowbound + (long)(b + 1 - bucket) * this.bucketSpec[i][1];
            }
            bucket = (int)((long)bucket + this.bucketSpec[i][0]);
            lowbound = this.bucketBounds[i];
        }
        return Long.MAX_VALUE;
    }

    public long getBucketValue(int b) {
        if (this.numBuckets == 0) {
            return -1L;
        }
        if (b == 0) {
            return this.getBucketBound(0) / 2L;
        }
        if (b == this.numBuckets - 1) {
            return 2L * this.getBucketBound(this.numBuckets - 2);
        }
        return (this.getBucketBound(b - 1) + this.getBucketBound(b)) / 2L;
    }

    private int getHash() {
        return (int)(Thread.currentThread().getId() % 3L);
    }

    protected int getTime() {
        return (int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getNow(int hash) {
        int tstop;
        Object object;
        int now = this.getTime() - this.startTime;
        if (now > this.lastTime[hash]) {
            object = this.locks[hash];
            synchronized (object) {
                if (now > this.lastTime[hash]) {
                    tstop = (now + 2) % this.timeWindow;
                    int t = (this.lastTime[hash] + 2) % this.timeWindow;
                    while (t != tstop) {
                        this.meter[hash][t] = 0;
                        t = (t + 1) % this.timeWindow;
                    }
                    t = (this.lastTime[hash] + 2) % this.timeWindow;
                    while (t != tstop) {
                        this.sum[hash][t] = 0L;
                        this.min[hash][t] = 0L;
                        this.max[hash][t] = 0L;
                        t = (t + 1) % this.timeWindow;
                    }
                    this.lastTime[hash] = now;
                }
            }
        }
        if (this.numBuckets <= 0 || now <= this.lastTimeBucket) return now % this.timeWindow;
        object = this.buckets;
        synchronized (this.buckets) {
            if (now <= this.lastTimeBucket) return now % this.timeWindow;
            tstop = (now + 2) % this.timeWindow;
            for (int b = 0; b < this.numBuckets; ++b) {
                int[] nArray = this.buckets[b];
                synchronized (nArray) {
                    int t = (this.lastTimeBucket + 2) % this.timeWindow;
                    while (t != tstop) {
                        this.buckets[b][t] = 0;
                        t = (t + 1) % this.timeWindow;
                    }
                    continue;
                }
            }
            this.lastTimeBucket = now;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return now % this.timeWindow;
        }
    }

    public double getRate(int seconds) {
        seconds = Math.min(seconds, this.timeWindow - 2);
        int t = this.getNow(this.getHash()) - 1;
        int secFrom = t - seconds;
        long sum = 0L;
        for (int h = 0; h < 3; ++h) {
            for (int i = t; i > secFrom; --i) {
                sum += (long)this.meter[h][(this.timeWindow + i) % this.timeWindow];
            }
        }
        return (double)sum / (double)seconds;
    }

    public long getCount() {
        long sum = 0L;
        for (AtomicLong c : this.counter) {
            sum += c.get();
        }
        return sum;
    }

    public double getFifteenMinuteRate() {
        return this.getRate(900);
    }

    public double getFiveMinuteRate() {
        return this.getRate(300);
    }

    public double getMeanRate() {
        return this.getRate(Integer.MAX_VALUE);
    }

    public double getOneMinuteRate() {
        return this.getRate(60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snapshot getSnapshot() {
        long sum = 0L;
        long cnt = 0L;
        long min = 0L;
        long max = 0L;
        int now = this.getNow(0) - 1;
        int secFrom = now - (this.timeWindow - 2);
        for (int i = 1; i < 3; ++i) {
            this.getNow(i);
        }
        long[] buckets = this.numBuckets > 0 ? new long[this.numBuckets] : null;
        for (int i = now; i > secFrom; --i) {
            int t = (this.timeWindow + i) % this.timeWindow;
            for (int h = 0; h < 3; ++h) {
                Object object = this.locks[h];
                synchronized (object) {
                    sum += this.sum[h][t];
                    cnt += (long)this.meter[h][t];
                    if (this.min[h][t] < min && this.min[h][t] > 0L || min == 0L) {
                        min = this.min[h][t];
                    }
                    if (this.max[h][t] > max) {
                        max = this.max[h][t];
                    }
                    continue;
                }
            }
            for (int b = 0; b < this.numBuckets; ++b) {
                int n = b;
                buckets[n] = buckets[n] + (long)this.buckets[b][t];
            }
        }
        return new FastSnapshot(this, min, max, sum, cnt, buckets);
    }

    public void update(long duration, TimeUnit unit) {
        this.update(unit.toNanos(duration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update(long duration) {
        if (duration < 1L) {
            duration = 1L;
        }
        int h = this.getHash();
        int t = this.getNow(h);
        this.counter[h].incrementAndGet();
        int b = this.getBucket(duration);
        Object object = this.locks[h];
        synchronized (object) {
            int[] nArray = this.meter[h];
            int n = t;
            nArray[n] = nArray[n] + 1;
            long[] lArray = this.sum[h];
            int n2 = t;
            lArray[n2] = lArray[n2] + duration;
            if (duration < this.min[h][t] || this.min[h][t] == 0L) {
                this.min[h][t] = duration;
            }
            if (duration > this.max[h][t]) {
                this.max[h][t] = duration;
            }
        }
        if (this.numBuckets <= 0) return;
        int[] nArray = this.buckets[b];
        object = nArray;
        synchronized (nArray) {
            int[] nArray2 = this.buckets[b];
            int n = t;
            nArray2[n] = nArray2[n] + 1;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    private static class DummyReservoir
    implements Reservoir {
        private DummyReservoir() {
        }

        public int size() {
            return 0;
        }

        public void update(long value) {
        }

        public Snapshot getSnapshot() {
            return null;
        }
    }

    public static enum Buckets {
        fine,
        coarse,
        none;

    }
}

