/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.collections;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.collections.BusyWait;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscArrayQueue;

public class BlockingMpscQueue<T>
extends MpscArrayQueue<T>
implements BlockingQueue<T> {
    private static final MessagePassingQueue.WaitStrategy SPIN_STRATEGY;
    private static final MessagePassingQueue.WaitStrategy WAIT_STRATEGY;

    public BlockingMpscQueue(int size) {
        super(size);
    }

    @Override
    public void put(T e) throws InterruptedException {
        while (!this.relaxedOffer(e)) {
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
    }

    @Override
    public boolean offer(T e, long timeout, TimeUnit unit) throws InterruptedException {
        long absoluteEndTime = System.nanoTime() + unit.toNanos(timeout);
        while (!this.relaxedOffer(e)) {
            if (System.nanoTime() > absoluteEndTime) {
                return false;
            }
            if (!Thread.interrupted()) continue;
            throw new InterruptedException();
        }
        return true;
    }

    @Override
    public T take() throws InterruptedException {
        Object item;
        int idleCounter = 0;
        while ((item = this.relaxedPoll()) == null) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            idleCounter = WAIT_STRATEGY.idle(idleCounter);
        }
        return (T)item;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object item;
        long absoluteEndTime = System.nanoTime() + unit.toNanos(timeout);
        int idleCounter = 0;
        while ((item = this.relaxedPoll()) == null) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (System.nanoTime() > absoluteEndTime) {
                return null;
            }
            idleCounter = WAIT_STRATEGY.idle(idleCounter);
        }
        return (T)item;
    }

    @Override
    public int remainingCapacity() {
        return this.capacity() - this.size();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        int initialSize = c.size();
        DrainStrategy ds = new DrainStrategy();
        this.drain(c::add, ds, ds);
        return c.size() - initialSize;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        return this.drain(c::add, maxElements);
    }

    static {
        WAIT_STRATEGY = SPIN_STRATEGY = new MessagePassingQueue.WaitStrategy(){

            public int idle(int idleCounter) {
                BusyWait.onSpinWait();
                return idleCounter + 1;
            }
        };
    }

    private static final class DrainStrategy
    implements MessagePassingQueue.WaitStrategy,
    MessagePassingQueue.ExitCondition {
        boolean reachedEnd = false;

        private DrainStrategy() {
        }

        public boolean keepRunning() {
            return !this.reachedEnd;
        }

        public int idle(int idleCounter) {
            this.reachedEnd = true;
            return idleCounter;
        }
    }
}

