/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.GetStatsOptions;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.shade.org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PartitionedTopicInternalStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicStats;

public interface Topics {
    public List<String> getList(String var1) throws PulsarAdminException;

    public List<String> getList(String var1, TopicDomain var2) throws PulsarAdminException;

    public CompletableFuture<List<String>> getListAsync(String var1);

    public CompletableFuture<List<String>> getListAsync(String var1, TopicDomain var2);

    public List<String> getPartitionedTopicList(String var1) throws PulsarAdminException;

    public CompletableFuture<List<String>> getPartitionedTopicListAsync(String var1);

    public List<String> getListInBundle(String var1, String var2) throws PulsarAdminException;

    public CompletableFuture<List<String>> getListInBundleAsync(String var1, String var2);

    public Map<String, Set<AuthAction>> getPermissions(String var1) throws PulsarAdminException;

    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(String var1);

    public void grantPermission(String var1, String var2, Set<AuthAction> var3) throws PulsarAdminException;

    public CompletableFuture<Void> grantPermissionAsync(String var1, String var2, Set<AuthAction> var3);

    public void revokePermissions(String var1, String var2) throws PulsarAdminException;

    public CompletableFuture<Void> revokePermissionsAsync(String var1, String var2);

    default public void createPartitionedTopic(String topic, int numPartitions) throws PulsarAdminException {
        this.createPartitionedTopic(topic, numPartitions, null);
    }

    public void createPartitionedTopic(String var1, int var2, Map<String, String> var3) throws PulsarAdminException;

    default public CompletableFuture<Void> createPartitionedTopicAsync(String topic, int numPartitions) {
        return this.createPartitionedTopicAsync(topic, numPartitions, null);
    }

    public CompletableFuture<Void> createPartitionedTopicAsync(String var1, int var2, Map<String, String> var3);

    default public void createNonPartitionedTopic(String topic) throws PulsarAdminException {
        this.createNonPartitionedTopic(topic, null);
    }

    public void createNonPartitionedTopic(String var1, Map<String, String> var2) throws PulsarAdminException;

    default public CompletableFuture<Void> createNonPartitionedTopicAsync(String topic) {
        return this.createNonPartitionedTopicAsync(topic, null);
    }

    public CompletableFuture<Void> createNonPartitionedTopicAsync(String var1, Map<String, String> var2);

    public void createMissedPartitions(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> createMissedPartitionsAsync(String var1);

    public void updatePartitionedTopic(String var1, int var2) throws PulsarAdminException;

    public CompletableFuture<Void> updatePartitionedTopicAsync(String var1, int var2);

    public void updatePartitionedTopic(String var1, int var2, boolean var3, boolean var4) throws PulsarAdminException;

    public CompletableFuture<Void> updatePartitionedTopicAsync(String var1, int var2, boolean var3, boolean var4);

    public void updatePartitionedTopic(String var1, int var2, boolean var3) throws PulsarAdminException;

    public CompletableFuture<Void> updatePartitionedTopicAsync(String var1, int var2, boolean var3);

    public PartitionedTopicMetadata getPartitionedTopicMetadata(String var1) throws PulsarAdminException;

    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(String var1);

    public void deletePartitionedTopic(String var1, boolean var2, boolean var3) throws PulsarAdminException;

    default public void deletePartitionedTopic(String topic, boolean force) throws PulsarAdminException {
        this.deletePartitionedTopic(topic, force, false);
    }

    public CompletableFuture<Void> deletePartitionedTopicAsync(String var1, boolean var2, boolean var3);

    default public CompletableFuture<Void> deletePartitionedTopicAsync(String topic, boolean force) {
        return this.deletePartitionedTopicAsync(topic, force, false);
    }

    public void deletePartitionedTopic(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> deletePartitionedTopicAsync(String var1);

    public void delete(String var1, boolean var2, boolean var3) throws PulsarAdminException;

    default public void delete(String topic, boolean force) throws PulsarAdminException {
        this.delete(topic, force, false);
    }

    public CompletableFuture<Void> deleteAsync(String var1, boolean var2, boolean var3);

    default public CompletableFuture<Void> deleteAsync(String topic, boolean force) {
        return this.deleteAsync(topic, force, false);
    }

    public void delete(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> deleteAsync(String var1);

    public void unload(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> unloadAsync(String var1);

    public MessageId terminateTopic(String var1) throws PulsarAdminException;

    public CompletableFuture<MessageId> terminateTopicAsync(String var1);

    public Map<Integer, MessageId> terminatePartitionedTopic(String var1) throws PulsarAdminException;

    public CompletableFuture<Map<Integer, MessageId>> terminatePartitionedTopicAsync(String var1);

    public List<String> getSubscriptions(String var1) throws PulsarAdminException;

    public CompletableFuture<List<String>> getSubscriptionsAsync(String var1);

    public TopicStats getStats(String var1, GetStatsOptions var2) throws PulsarAdminException;

    default public TopicStats getStats(String topic, boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog) throws PulsarAdminException {
        GetStatsOptions getStatsOptions = new GetStatsOptions(getPreciseBacklog, subscriptionBacklogSize, getEarliestTimeInBacklog);
        return this.getStats(topic, getStatsOptions);
    }

    default public TopicStats getStats(String topic, boolean getPreciseBacklog, boolean subscriptionBacklogSize) throws PulsarAdminException {
        GetStatsOptions getStatsOptions = new GetStatsOptions(getPreciseBacklog, subscriptionBacklogSize, false);
        return this.getStats(topic, getStatsOptions);
    }

    default public TopicStats getStats(String topic, boolean getPreciseBacklog) throws PulsarAdminException {
        GetStatsOptions getStatsOptions = new GetStatsOptions(getPreciseBacklog, false, false);
        return this.getStats(topic, getStatsOptions);
    }

    default public TopicStats getStats(String topic) throws PulsarAdminException {
        return this.getStats(topic, new GetStatsOptions(false, false, false));
    }

    public CompletableFuture<TopicStats> getStatsAsync(String var1, boolean var2, boolean var3, boolean var4);

    default public CompletableFuture<TopicStats> getStatsAsync(String topic) {
        return this.getStatsAsync(topic, false, false, false);
    }

    public PersistentTopicInternalStats getInternalStats(String var1, boolean var2) throws PulsarAdminException;

    public PersistentTopicInternalStats getInternalStats(String var1) throws PulsarAdminException;

    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String var1, boolean var2);

    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String var1);

    public String getInternalInfo(String var1) throws PulsarAdminException;

    public CompletableFuture<String> getInternalInfoAsync(String var1);

    public PartitionedTopicStats getPartitionedStats(String var1, boolean var2, boolean var3, boolean var4) throws PulsarAdminException;

    default public PartitionedTopicStats getPartitionedStats(String topic, boolean perPartition) throws PulsarAdminException {
        return this.getPartitionedStats(topic, perPartition, false, false);
    }

    public CompletableFuture<PartitionedTopicStats> getPartitionedStatsAsync(String var1, boolean var2, boolean var3, boolean var4);

    default public CompletableFuture<PartitionedTopicStats> getPartitionedStatsAsync(String topic, boolean perPartition) {
        return this.getPartitionedStatsAsync(topic, perPartition, false, false);
    }

    public PartitionedTopicInternalStats getPartitionedInternalStats(String var1) throws PulsarAdminException;

    public CompletableFuture<PartitionedTopicInternalStats> getPartitionedInternalStatsAsync(String var1);

    public void deleteSubscription(String var1, String var2) throws PulsarAdminException;

    public void deleteSubscription(String var1, String var2, boolean var3) throws PulsarAdminException;

    public CompletableFuture<Void> deleteSubscriptionAsync(String var1, String var2);

    public CompletableFuture<Void> deleteSubscriptionAsync(String var1, String var2, boolean var3);

    public void skipAllMessages(String var1, String var2) throws PulsarAdminException;

    public CompletableFuture<Void> skipAllMessagesAsync(String var1, String var2);

    public void skipMessages(String var1, String var2, long var3) throws PulsarAdminException;

    public CompletableFuture<Void> skipMessagesAsync(String var1, String var2, long var3);

    public void expireMessages(String var1, String var2, long var3) throws PulsarAdminException;

    public CompletableFuture<Void> expireMessagesAsync(String var1, String var2, long var3);

    public void expireMessages(String var1, String var2, MessageId var3, boolean var4) throws PulsarAdminException;

    public CompletableFuture<Void> expireMessagesAsync(String var1, String var2, MessageId var3, boolean var4);

    public void expireMessagesForAllSubscriptions(String var1, long var2) throws PulsarAdminException;

    public CompletableFuture<Void> expireMessagesForAllSubscriptionsAsync(String var1, long var2);

    public List<Message<byte[]>> peekMessages(String var1, String var2, int var3) throws PulsarAdminException;

    public CompletableFuture<List<Message<byte[]>>> peekMessagesAsync(String var1, String var2, int var3);

    public Message<byte[]> getMessageById(String var1, long var2, long var4) throws PulsarAdminException;

    public CompletableFuture<Message<byte[]>> getMessageByIdAsync(String var1, long var2, long var4);

    public MessageId getMessageIdByTimestamp(String var1, long var2) throws PulsarAdminException;

    public CompletableFuture<MessageId> getMessageIdByTimestampAsync(String var1, long var2);

    public void createSubscription(String var1, String var2, MessageId var3) throws PulsarAdminException;

    public CompletableFuture<Void> createSubscriptionAsync(String var1, String var2, MessageId var3);

    public void resetCursor(String var1, String var2, long var3) throws PulsarAdminException;

    public void resetCursor(String var1, String var2, MessageId var3, boolean var4) throws PulsarAdminException;

    public CompletableFuture<Void> resetCursorAsync(String var1, String var2, long var3);

    public CompletableFuture<Void> resetCursorAsync(String var1, String var2, MessageId var3, boolean var4);

    public void resetCursor(String var1, String var2, MessageId var3) throws PulsarAdminException;

    public CompletableFuture<Void> resetCursorAsync(String var1, String var2, MessageId var3);

    public void triggerCompaction(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> triggerCompactionAsync(String var1);

    public LongRunningProcessStatus compactionStatus(String var1) throws PulsarAdminException;

    public CompletableFuture<LongRunningProcessStatus> compactionStatusAsync(String var1);

    public void triggerOffload(String var1, MessageId var2) throws PulsarAdminException;

    public CompletableFuture<Void> triggerOffloadAsync(String var1, MessageId var2);

    public OffloadProcessStatus offloadStatus(String var1) throws PulsarAdminException;

    public CompletableFuture<OffloadProcessStatus> offloadStatusAsync(String var1);

    public MessageId getLastMessageId(String var1) throws PulsarAdminException;

    public CompletableFuture<MessageId> getLastMessageIdAsync(String var1);

    @Deprecated
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String var1) throws PulsarAdminException;

    @Deprecated
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String var1, boolean var2) throws PulsarAdminException;

    public Long getBacklogSizeByMessageId(String var1, MessageId var2) throws PulsarAdminException;

    public CompletableFuture<Long> getBacklogSizeByMessageIdAsync(String var1, MessageId var2);

    @Deprecated
    public void setBacklogQuota(String var1, BacklogQuota var2, BacklogQuota.BacklogQuotaType var3) throws PulsarAdminException;

    @Deprecated
    default public void setBacklogQuota(String topic, BacklogQuota backlogQuota) throws PulsarAdminException {
        this.setBacklogQuota(topic, backlogQuota, BacklogQuota.BacklogQuotaType.destination_storage);
    }

    @Deprecated
    public void removeBacklogQuota(String var1, BacklogQuota.BacklogQuotaType var2) throws PulsarAdminException;

    @Deprecated
    default public void removeBacklogQuota(String topic) throws PulsarAdminException {
        this.removeBacklogQuota(topic, BacklogQuota.BacklogQuotaType.destination_storage);
    }

    @Deprecated
    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String var1, boolean var2);

    @Deprecated
    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String var1);

    @Deprecated
    public void setDelayedDeliveryPolicy(String var1, DelayedDeliveryPolicies var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setDelayedDeliveryPolicyAsync(String var1, DelayedDeliveryPolicies var2);

    @Deprecated
    public CompletableFuture<Void> removeDelayedDeliveryPolicyAsync(String var1);

    @Deprecated
    public void removeDelayedDeliveryPolicy(String var1) throws PulsarAdminException;

    @Deprecated
    public void setMessageTTL(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public Integer getMessageTTL(String var1) throws PulsarAdminException;

    @Deprecated
    public Integer getMessageTTL(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public void removeMessageTTL(String var1) throws PulsarAdminException;

    @Deprecated
    public void setRetention(String var1, RetentionPolicies var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setRetentionAsync(String var1, RetentionPolicies var2);

    @Deprecated
    public RetentionPolicies getRetention(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<RetentionPolicies> getRetentionAsync(String var1);

    @Deprecated
    public RetentionPolicies getRetention(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<RetentionPolicies> getRetentionAsync(String var1, boolean var2);

    @Deprecated
    public void removeRetention(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeRetentionAsync(String var1);

    @Deprecated
    public Integer getMaxUnackedMessagesOnConsumer(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String var1);

    @Deprecated
    public Integer getMaxUnackedMessagesOnConsumer(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String var1, boolean var2);

    @Deprecated
    public void setMaxUnackedMessagesOnConsumer(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxUnackedMessagesOnConsumerAsync(String var1, int var2);

    @Deprecated
    public void removeMaxUnackedMessagesOnConsumer(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxUnackedMessagesOnConsumerAsync(String var1);

    @Deprecated
    public InactiveTopicPolicies getInactiveTopicPolicies(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String var1, boolean var2);

    @Deprecated
    public InactiveTopicPolicies getInactiveTopicPolicies(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String var1);

    @Deprecated
    public void setInactiveTopicPolicies(String var1, InactiveTopicPolicies var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String var1, InactiveTopicPolicies var2);

    @Deprecated
    public void removeInactiveTopicPolicies(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String var1);

    @Deprecated
    public OffloadPolicies getOffloadPolicies(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String var1);

    @Deprecated
    public OffloadPolicies getOffloadPolicies(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String var1, boolean var2);

    @Deprecated
    public void setOffloadPolicies(String var1, OffloadPolicies var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setOffloadPoliciesAsync(String var1, OffloadPolicies var2);

    @Deprecated
    public void removeOffloadPolicies(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeOffloadPoliciesAsync(String var1);

    @Deprecated
    public Integer getMaxUnackedMessagesOnSubscription(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String var1);

    @Deprecated
    public Integer getMaxUnackedMessagesOnSubscription(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String var1, boolean var2);

    @Deprecated
    public void setMaxUnackedMessagesOnSubscription(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxUnackedMessagesOnSubscriptionAsync(String var1, int var2);

    @Deprecated
    public void removeMaxUnackedMessagesOnSubscription(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxUnackedMessagesOnSubscriptionAsync(String var1);

    @Deprecated
    public void setPersistence(String var1, PersistencePolicies var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setPersistenceAsync(String var1, PersistencePolicies var2);

    @Deprecated
    public PersistencePolicies getPersistence(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String var1);

    @Deprecated
    public PersistencePolicies getPersistence(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String var1, boolean var2);

    @Deprecated
    public void removePersistence(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removePersistenceAsync(String var1);

    @Deprecated
    public Boolean getDeduplicationEnabled(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Boolean> getDeduplicationEnabledAsync(String var1);

    @Deprecated
    public Boolean getDeduplicationStatus(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String var1);

    @Deprecated
    public Boolean getDeduplicationStatus(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String var1, boolean var2);

    @Deprecated
    public void enableDeduplication(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> enableDeduplicationAsync(String var1, boolean var2);

    @Deprecated
    public void setDeduplicationStatus(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setDeduplicationStatusAsync(String var1, boolean var2);

    @Deprecated
    public void disableDeduplication(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> disableDeduplicationAsync(String var1);

    @Deprecated
    public void removeDeduplicationStatus(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeDeduplicationStatusAsync(String var1);

    @Deprecated
    public void setDispatchRate(String var1, DispatchRate var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setDispatchRateAsync(String var1, DispatchRate var2);

    @Deprecated
    public DispatchRate getDispatchRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DispatchRate> getDispatchRateAsync(String var1);

    @Deprecated
    public DispatchRate getDispatchRate(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DispatchRate> getDispatchRateAsync(String var1, boolean var2);

    @Deprecated
    public void removeDispatchRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeDispatchRateAsync(String var1) throws PulsarAdminException;

    @Deprecated
    public void setSubscriptionDispatchRate(String var1, DispatchRate var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String var1, DispatchRate var2);

    @Deprecated
    public DispatchRate getSubscriptionDispatchRate(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String var1, boolean var2);

    @Deprecated
    public DispatchRate getSubscriptionDispatchRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String var1);

    @Deprecated
    public void removeSubscriptionDispatchRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String var1);

    @Deprecated
    public void setReplicatorDispatchRate(String var1, DispatchRate var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String var1, DispatchRate var2);

    @Deprecated
    public DispatchRate getReplicatorDispatchRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String var1);

    @Deprecated
    public DispatchRate getReplicatorDispatchRate(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String var1, boolean var2);

    @Deprecated
    public void removeReplicatorDispatchRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String var1);

    @Deprecated
    public Long getCompactionThreshold(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Long> getCompactionThresholdAsync(String var1);

    @Deprecated
    public Long getCompactionThreshold(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Long> getCompactionThresholdAsync(String var1, boolean var2);

    @Deprecated
    public void setCompactionThreshold(String var1, long var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setCompactionThresholdAsync(String var1, long var2);

    @Deprecated
    public void removeCompactionThreshold(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeCompactionThresholdAsync(String var1);

    @Deprecated
    public void setPublishRate(String var1, PublishRate var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setPublishRateAsync(String var1, PublishRate var2);

    @Deprecated
    public PublishRate getPublishRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<PublishRate> getPublishRateAsync(String var1);

    @Deprecated
    public void removePublishRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removePublishRateAsync(String var1) throws PulsarAdminException;

    @Deprecated
    public Integer getMaxConsumersPerSubscription(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String var1);

    @Deprecated
    public void setMaxConsumersPerSubscription(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String var1, int var2);

    @Deprecated
    public void removeMaxConsumersPerSubscription(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String var1);

    @Deprecated
    public Integer getMaxProducers(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxProducersAsync(String var1);

    @Deprecated
    public Integer getMaxProducers(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxProducersAsync(String var1, boolean var2);

    @Deprecated
    public void setMaxProducers(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxProducersAsync(String var1, int var2);

    @Deprecated
    public void removeMaxProducers(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxProducersAsync(String var1);

    @Deprecated
    public Integer getMaxSubscriptionsPerTopic(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String var1);

    @Deprecated
    public void setMaxSubscriptionsPerTopic(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String var1, int var2);

    @Deprecated
    public void removeMaxSubscriptionsPerTopic(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String var1);

    @Deprecated
    public Integer getMaxMessageSize(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxMessageSizeAsync(String var1);

    @Deprecated
    public void setMaxMessageSize(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxMessageSizeAsync(String var1, int var2);

    @Deprecated
    public void removeMaxMessageSize(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxMessageSizeAsync(String var1);

    @Deprecated
    public Integer getMaxConsumers(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxConsumersAsync(String var1);

    @Deprecated
    public Integer getMaxConsumers(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getMaxConsumersAsync(String var1, boolean var2);

    @Deprecated
    public void setMaxConsumers(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setMaxConsumersAsync(String var1, int var2);

    @Deprecated
    public void removeMaxConsumers(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeMaxConsumersAsync(String var1);

    @Deprecated
    public Integer getDeduplicationSnapshotInterval(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String var1);

    @Deprecated
    public void setDeduplicationSnapshotInterval(String var1, int var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String var1, int var2);

    @Deprecated
    public void removeDeduplicationSnapshotInterval(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String var1);

    @Deprecated
    public void setSubscriptionTypesEnabled(String var1, Set<SubscriptionType> var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String var1, Set<SubscriptionType> var2);

    @Deprecated
    public Set<SubscriptionType> getSubscriptionTypesEnabled(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String var1);

    @Deprecated
    public void removeSubscriptionTypesEnabled(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeSubscriptionTypesEnabledAsync(String var1);

    @Deprecated
    public void setSubscribeRate(String var1, SubscribeRate var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> setSubscribeRateAsync(String var1, SubscribeRate var2);

    @Deprecated
    public SubscribeRate getSubscribeRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String var1);

    @Deprecated
    public SubscribeRate getSubscribeRate(String var1, boolean var2) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String var1, boolean var2);

    @Deprecated
    public void removeSubscribeRate(String var1) throws PulsarAdminException;

    @Deprecated
    public CompletableFuture<Void> removeSubscribeRateAsync(String var1) throws PulsarAdminException;

    public Message<byte[]> examineMessage(String var1, String var2, long var3) throws PulsarAdminException;

    public CompletableFuture<Message<byte[]>> examineMessageAsync(String var1, String var2, long var3) throws PulsarAdminException;

    public void truncate(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> truncateAsync(String var1);

    public void setReplicatedSubscriptionStatus(String var1, String var2, boolean var3) throws PulsarAdminException;

    public CompletableFuture<Void> setReplicatedSubscriptionStatusAsync(String var1, String var2, boolean var3);

    public Set<String> getReplicationClusters(String var1, boolean var2) throws PulsarAdminException;

    public CompletableFuture<Set<String>> getReplicationClustersAsync(String var1, boolean var2);

    public void setReplicationClusters(String var1, List<String> var2) throws PulsarAdminException;

    public CompletableFuture<Void> setReplicationClustersAsync(String var1, List<String> var2);

    public void removeReplicationClusters(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> removeReplicationClustersAsync(String var1);

    public Map<String, Boolean> getReplicatedSubscriptionStatus(String var1, String var2) throws PulsarAdminException;

    public CompletableFuture<Map<String, Boolean>> getReplicatedSubscriptionStatusAsync(String var1, String var2);
}

