/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.service.plugin.EntryFilterDefinition;
import org.apache.pulsar.broker.service.plugin.EntryFilterDefinitions;
import org.apache.pulsar.broker.service.plugin.EntryFilterMetaData;
import org.apache.pulsar.broker.service.plugin.EntryFilterWithClassLoader;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryFilterProvider {
    private static final Logger log = LoggerFactory.getLogger(EntryFilterProvider.class);
    static final String ENTRY_FILTER_DEFINITION_FILE = "entry_filter.yml";

    public static ImmutableMap<String, EntryFilterWithClassLoader> createEntryFilters(ServiceConfiguration conf) throws IOException {
        EntryFilterDefinitions definitions = EntryFilterProvider.searchForEntryFilters(conf.getEntryFiltersDirectory(), conf.getNarExtractionDirectory());
        ImmutableMap.Builder<String, EntryFilterWithClassLoader> builder = ImmutableMap.builder();
        for (String filterName : conf.getEntryFilterNames()) {
            EntryFilterMetaData metaData = definitions.getFilters().get(filterName);
            if (null == metaData) {
                throw new RuntimeException("No entry filter is found for name `" + filterName + "`. Available entry filters are : " + definitions.getFilters());
            }
            EntryFilterWithClassLoader filter = EntryFilterProvider.load(metaData, conf.getNarExtractionDirectory());
            if (filter != null) {
                builder.put(filterName, filter);
            }
            log.info("Successfully loaded entry filter for name `{}`", (Object)filterName);
        }
        return builder.build();
    }

    private static EntryFilterDefinitions searchForEntryFilters(String entryFiltersDirectory, String narExtractionDirectory) throws IOException {
        Path path = Paths.get(entryFiltersDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for entry filters in {}", (Object)path);
        EntryFilterDefinitions entryFilterDefinitions = new EntryFilterDefinitions();
        if (!path.toFile().exists()) {
            log.info("Pulsar entry filters directory not found");
            return entryFilterDefinitions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    EntryFilterDefinition def = EntryFilterProvider.getEntryFilterDefinition(archive.toString(), narExtractionDirectory);
                    log.info("Found entry filter from {} : {}", (Object)archive, (Object)def);
                    Preconditions.checkArgument(StringUtils.isNotBlank(def.getName()));
                    Preconditions.checkArgument(StringUtils.isNotBlank(def.getEntryFilterClass()));
                    EntryFilterMetaData metadata = new EntryFilterMetaData();
                    metadata.setDefinition(def);
                    metadata.setArchivePath(archive);
                    entryFilterDefinitions.getFilters().put(def.getName(), metadata);
                }
                catch (Throwable t) {
                    log.warn("Failed to load entry filters from {}. It is OK however if you want to use this entry filters, please make sure you put the correct entry filter NAR package in the entry filter directory.", (Object)archive, (Object)t);
                }
            }
        }
        return entryFilterDefinitions;
    }

    private static EntryFilterDefinition getEntryFilterDefinition(String narPath, String narExtractionDirectory) throws IOException {
        try (NarClassLoader ncl = NarClassLoader.getFromArchive(new File(narPath), Collections.emptySet(), narExtractionDirectory);){
            EntryFilterDefinition entryFilterDefinition = EntryFilterProvider.getEntryFilterDefinition(ncl);
            return entryFilterDefinition;
        }
    }

    private static EntryFilterDefinition getEntryFilterDefinition(NarClassLoader ncl) throws IOException {
        String configStr = ncl.getServiceDefinition(ENTRY_FILTER_DEFINITION_FILE);
        return ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, EntryFilterDefinition.class);
    }

    private static EntryFilterWithClassLoader load(EntryFilterMetaData metadata, String narExtractionDirectory) throws IOException {
        NarClassLoader ncl = NarClassLoader.getFromArchive(metadata.getArchivePath().toAbsolutePath().toFile(), Collections.emptySet(), EntryFilter.class.getClassLoader(), narExtractionDirectory);
        EntryFilterDefinition def = EntryFilterProvider.getEntryFilterDefinition(ncl);
        if (StringUtils.isBlank(def.getEntryFilterClass())) {
            throw new IOException("Entry filters `" + def.getName() + "` does NOT provide a entry filters implementation");
        }
        try {
            Class<?> entryFilterClass = ncl.loadClass(def.getEntryFilterClass());
            Object filter = entryFilterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!(filter instanceof EntryFilter)) {
                throw new IOException("Class " + def.getEntryFilterClass() + " does not implement entry filter interface");
            }
            EntryFilter pi = (EntryFilter)filter;
            return new EntryFilterWithClassLoader(pi, ncl);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            log.error("Failed to load class {}", (Object)def.getEntryFilterClass(), (Object)e);
            throw new IOException(e);
        }
    }
}

