/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;

public class CleanupLedgerManager
implements LedgerManager {
    private final LedgerManager underlying;
    private final ConcurrentMap<BookkeeperInternalCallbacks.GenericCallback, BookkeeperInternalCallbacks.GenericCallback> callbacks = new ConcurrentHashMap<BookkeeperInternalCallbacks.GenericCallback, BookkeeperInternalCallbacks.GenericCallback>();
    private boolean closed = false;
    private final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final Set<CompletableFuture<?>> futures = ConcurrentHashMap.newKeySet();

    public CleanupLedgerManager(LedgerManager lm) {
        this.underlying = lm;
    }

    @VisibleForTesting
    public LedgerManager getUnderlying() {
        return this.underlying;
    }

    private void addCallback(BookkeeperInternalCallbacks.GenericCallback callback) {
        this.callbacks.put(callback, callback);
    }

    @Override
    public void registerLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        this.underlying.registerLedgerMetadataListener(ledgerId, listener);
    }

    @Override
    public void unregisterLedgerMetadataListener(long ledgerId, BookkeeperInternalCallbacks.LedgerMetadataListener listener) {
        this.underlying.unregisterLedgerMetadataListener(ledgerId, listener);
    }

    private BookkeeperInternalCallbacks.GenericCallback removeCallback(BookkeeperInternalCallbacks.GenericCallback callback) {
        return (BookkeeperInternalCallbacks.GenericCallback)this.callbacks.remove(callback);
    }

    private void recordPromise(CompletableFuture<?> promise) {
        this.futures.add(promise);
        promise.thenRun(() -> this.futures.remove(promise));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Versioned<LedgerMetadata>> createLedgerMetadata(long lid, LedgerMetadata metadata) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                CompletableFuture<Versioned<LedgerMetadata>> completableFuture = CleanupLedgerManager.closedPromise();
                return completableFuture;
            }
            CompletableFuture<Versioned<LedgerMetadata>> promise = this.underlying.createLedgerMetadata(lid, metadata);
            this.recordPromise(promise);
            CompletableFuture<Versioned<LedgerMetadata>> completableFuture = promise;
            return completableFuture;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> removeLedgerMetadata(long ledgerId, Version version) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                CompletableFuture<Void> completableFuture = CleanupLedgerManager.closedPromise();
                return completableFuture;
            }
            CompletableFuture<Void> promise = this.underlying.removeLedgerMetadata(ledgerId, version);
            this.recordPromise(promise);
            CompletableFuture<Void> completableFuture = promise;
            return completableFuture;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Versioned<LedgerMetadata>> readLedgerMetadata(long ledgerId) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                CompletableFuture<Versioned<LedgerMetadata>> completableFuture = CleanupLedgerManager.closedPromise();
                return completableFuture;
            }
            CompletableFuture<Versioned<LedgerMetadata>> promise = this.underlying.readLedgerMetadata(ledgerId);
            this.recordPromise(promise);
            CompletableFuture<Versioned<LedgerMetadata>> completableFuture = promise;
            return completableFuture;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Versioned<LedgerMetadata>> writeLedgerMetadata(long ledgerId, LedgerMetadata metadata, Version currentVersion) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                CompletableFuture<Versioned<LedgerMetadata>> completableFuture = CleanupLedgerManager.closedPromise();
                return completableFuture;
            }
            CompletableFuture<Versioned<LedgerMetadata>> promise = this.underlying.writeLedgerMetadata(ledgerId, metadata, currentVersion);
            this.recordPromise(promise);
            CompletableFuture<Versioned<LedgerMetadata>> completableFuture = promise;
            return completableFuture;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, final AsyncCallback.VoidCallback finalCb, final Object context, int successRc, final int failureRc) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                finalCb.processResult(failureRc, null, context);
                return;
            }
            final BookkeeperInternalCallbacks.GenericCallback<Void> stub = new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                @Override
                public void operationComplete(int rc, Void result) {
                    finalCb.processResult(failureRc, null, context);
                }
            };
            this.addCallback(stub);
            this.underlying.asyncProcessLedgers(processor, new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    if (null != CleanupLedgerManager.this.removeCallback(stub)) {
                        finalCb.processResult(rc, path, ctx);
                    }
                }
            }, context, successRc, failureRc);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges(long zkOpTimeoutMs) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                ClosedLedgerRangeIterator closedLedgerRangeIterator = new ClosedLedgerRangeIterator();
                return closedLedgerRangeIterator;
            }
            LedgerManager.LedgerRangeIterator ledgerRangeIterator = this.underlying.getLedgerRanges(zkOpTimeoutMs);
            return ledgerRangeIterator;
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        HashSet keys;
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            keys = new HashSet(this.callbacks.keySet());
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        for (BookkeeperInternalCallbacks.GenericCallback key : keys) {
            BookkeeperInternalCallbacks.GenericCallback callback = (BookkeeperInternalCallbacks.GenericCallback)this.callbacks.remove(key);
            if (null == callback) continue;
            callback.operationComplete(-19, null);
        }
        BKException.BKClientClosedException exception = new BKException.BKClientClosedException();
        this.futures.forEach(f -> f.completeExceptionally(exception));
        this.futures.clear();
        this.underlying.close();
    }

    private static <T> CompletableFuture<T> closedPromise() {
        return FutureUtils.exception(new BKException.BKClientClosedException());
    }

    private static class ClosedLedgerRangeIterator
    implements LedgerManager.LedgerRangeIterator {
        private ClosedLedgerRangeIterator() {
        }

        @Override
        public boolean hasNext() throws IOException {
            throw new IOException("Ledger manager is closed.");
        }

        @Override
        public LedgerManager.LedgerRange next() throws IOException {
            throw new IOException("Ledger manager is closed.");
        }
    }

    private class CleanupGenericCallback<T>
    implements BookkeeperInternalCallbacks.GenericCallback<T> {
        private final BookkeeperInternalCallbacks.GenericCallback<T> cb;

        CleanupGenericCallback(BookkeeperInternalCallbacks.GenericCallback<T> cb) {
            this.cb = cb;
            CleanupLedgerManager.this.addCallback(cb);
        }

        @Override
        public void operationComplete(int rc, T result) {
            CleanupLedgerManager.this.closeLock.readLock().lock();
            try {
                if (!CleanupLedgerManager.this.closed && null != CleanupLedgerManager.this.removeCallback(this.cb)) {
                    this.cb.operationComplete(rc, result);
                }
            }
            finally {
                CleanupLedgerManager.this.closeLock.readLock().unlock();
            }
        }
    }
}

