/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.validators;

import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.Validator;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassValidator<T>
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(ClassValidator.class);
    private final Class<T> interfaceClass;

    public static <T> ClassValidator<T> of(Class<T> interfaceClass) {
        return new ClassValidator<T>(interfaceClass);
    }

    @Override
    public boolean validate(String name, Object value) {
        if (value instanceof String) {
            try {
                ReflectionUtils.forName((String)value, this.interfaceClass);
                return true;
            }
            catch (RuntimeException re) {
                log.warn("Setting value of '{}' is not '{}' : {}", new Object[]{name, this.interfaceClass.getName(), value, re});
                return false;
            }
        }
        if (value instanceof Class) {
            Class cls = (Class)value;
            if (!this.interfaceClass.isAssignableFrom(cls)) {
                log.warn("Setting value of '{}' is not '{}' : {}", new Object[]{name, this.interfaceClass.getName(), cls.getName()});
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "Class extends " + this.interfaceClass.getName();
    }

    @Override
    public String documentation() {
        return "class extends `" + this.interfaceClass.getName() + "`";
    }

    public ClassValidator(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class<T> getInterfaceClass() {
        return this.interfaceClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassValidator)) {
            return false;
        }
        ClassValidator other = (ClassValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<T> this$interfaceClass = this.getInterfaceClass();
        Class<T> other$interfaceClass = other.getInterfaceClass();
        return !(this$interfaceClass == null ? other$interfaceClass != null : !this$interfaceClass.equals(other$interfaceClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClassValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $interfaceClass = this.getInterfaceClass();
        result = result * 59 + ($interfaceClass == null ? 43 : $interfaceClass.hashCode());
        return result;
    }
}

