/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.pulsar.shade.com.carrotsearch.hppc.IntIntHashMap;

public class IntIntScatterMap
extends IntIntHashMap {
    public IntIntScatterMap() {
        this(4);
    }

    public IntIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntIntScatterMap from(int[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntIntScatterMap map = new IntIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

