/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack.impl;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckReplyCallBack;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadata;
import org.apache.pulsar.broker.transaction.pendingack.proto.PendingAckMetadataEntry;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandAck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MLPendingAckReplyCallBack
implements PendingAckReplyCallBack {
    private final PendingAckHandleImpl pendingAckHandle;
    private static final Logger log = LoggerFactory.getLogger(MLPendingAckReplyCallBack.class);

    public MLPendingAckReplyCallBack(PendingAckHandleImpl pendingAckHandle) {
        this.pendingAckHandle = pendingAckHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replayComplete() {
        PendingAckHandleImpl pendingAckHandleImpl = this.pendingAckHandle;
        synchronized (pendingAckHandleImpl) {
            log.info("Topic name : [{}], SubName : [{}] pending ack state reply success!", (Object)this.pendingAckHandle.getTopicName(), (Object)this.pendingAckHandle.getSubName());
            if (this.pendingAckHandle.changeToReadyState()) {
                this.pendingAckHandle.completeHandleFuture();
                log.info("Topic name : [{}], SubName : [{}] pending ack handle cache request success!", (Object)this.pendingAckHandle.getTopicName(), (Object)this.pendingAckHandle.getSubName());
            } else {
                log.error("Topic name : [{}], SubName : [{}] pending ack state reply fail!", (Object)this.pendingAckHandle.getTopicName(), (Object)this.pendingAckHandle.getSubName());
            }
        }
        this.pendingAckHandle.handleCacheRequest();
    }

    @Override
    public void handleMetadataEntry(PendingAckMetadataEntry pendingAckMetadataEntry) {
        TxnID txnID = new TxnID(pendingAckMetadataEntry.getTxnidMostBits(), pendingAckMetadataEntry.getTxnidLeastBits());
        CommandAck.AckType ackType = pendingAckMetadataEntry.getAckType();
        switch (pendingAckMetadataEntry.getPendingAckOp()) {
            case ABORT: {
                this.pendingAckHandle.handleAbort(txnID, ackType);
                break;
            }
            case COMMIT: {
                this.pendingAckHandle.handleCommit(txnID, ackType, Collections.emptyMap());
                break;
            }
            case ACK: {
                if (ackType == CommandAck.AckType.Cumulative) {
                    PendingAckMetadata pendingAckMetadata2 = pendingAckMetadataEntry.getPendingAckMetadatasList().get(0);
                    this.pendingAckHandle.handleCumulativeAckRecover(txnID, PositionImpl.get(pendingAckMetadata2.getLedgerId(), pendingAckMetadata2.getEntryId()));
                    break;
                }
                ArrayList<MutablePair<PositionImpl, Integer>> positions = new ArrayList<MutablePair<PositionImpl, Integer>>();
                pendingAckMetadataEntry.getPendingAckMetadatasList().forEach(pendingAckMetadata -> {
                    if (pendingAckMetadata.getAckSetsCount() == 0) {
                        positions.add(new MutablePair<PositionImpl, Integer>(PositionImpl.get(pendingAckMetadata.getLedgerId(), pendingAckMetadata.getEntryId()), pendingAckMetadata.getBatchSize()));
                    } else {
                        PositionImpl position = PositionImpl.get(pendingAckMetadata.getLedgerId(), pendingAckMetadata.getEntryId());
                        if (pendingAckMetadata.getAckSetsCount() > 0) {
                            long[] ackSets = new long[pendingAckMetadata.getAckSetsCount()];
                            for (int i = 0; i < pendingAckMetadata.getAckSetsCount(); ++i) {
                                ackSets[i] = pendingAckMetadata.getAckSetAt(i);
                            }
                            position.setAckSet(ackSets);
                        }
                        positions.add(new MutablePair<PositionImpl, Integer>(position, pendingAckMetadata.getBatchSize()));
                    }
                });
                this.pendingAckHandle.handleIndividualAckRecover(txnID, positions);
                break;
            }
            default: {
                throw new IllegalStateException("Transaction pending ack replay error with illegal state : " + (Object)((Object)pendingAckMetadataEntry.getPendingAckOp()));
            }
        }
    }
}

