/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.pulsar.broker.service.PublishRateLimiter;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RateLimitFunction;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RateLimiter;

public class PrecisPublishLimiter
implements PublishRateLimiter {
    protected volatile int publishMaxMessageRate = 0;
    protected volatile long publishMaxByteRate = 0L;
    private volatile RateLimiter topicPublishRateLimiterOnMessage;
    private volatile RateLimiter topicPublishRateLimiterOnByte;
    private final RateLimitFunction rateLimitFunction;
    private final ScheduledExecutorService scheduledExecutorService;

    public PrecisPublishLimiter(Policies policies, String clusterName, RateLimitFunction rateLimitFunction) {
        this.rateLimitFunction = rateLimitFunction;
        this.update(policies, clusterName);
        this.scheduledExecutorService = null;
    }

    public PrecisPublishLimiter(PublishRate publishRate, RateLimitFunction rateLimitFunction) {
        this(publishRate, rateLimitFunction, null);
    }

    public PrecisPublishLimiter(PublishRate publishRate, RateLimitFunction rateLimitFunction, ScheduledExecutorService scheduledExecutorService) {
        this.rateLimitFunction = rateLimitFunction;
        this.update(publishRate);
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void checkPublishRate() {
    }

    @Override
    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
    }

    @Override
    public boolean resetPublishCount() {
        return true;
    }

    @Override
    public boolean isPublishRateExceeded() {
        return false;
    }

    private void tryReleaseConnectionThrottle() {
        RateLimiter currentTopicPublishRateLimiterOnMessage = this.topicPublishRateLimiterOnMessage;
        RateLimiter currentTopicPublishRateLimiterOnByte = this.topicPublishRateLimiterOnByte;
        if (currentTopicPublishRateLimiterOnMessage != null && currentTopicPublishRateLimiterOnMessage.getAvailablePermits() <= 0L || currentTopicPublishRateLimiterOnByte != null && currentTopicPublishRateLimiterOnByte.getAvailablePermits() <= 0L) {
            return;
        }
        this.rateLimitFunction.apply();
    }

    @Override
    public void update(Policies policies, String clusterName) {
        PublishRate maxPublishRate = policies.publishMaxMessageRate != null ? policies.publishMaxMessageRate.get(clusterName) : null;
        this.update(maxPublishRate);
    }

    @Override
    public void update(PublishRate maxPublishRate) {
        this.replaceLimiters(() -> {
            if (maxPublishRate != null && (maxPublishRate.publishThrottlingRateInMsg > 0 || maxPublishRate.publishThrottlingRateInByte > 0L)) {
                this.publishMaxMessageRate = Math.max(maxPublishRate.publishThrottlingRateInMsg, 0);
                this.publishMaxByteRate = Math.max(maxPublishRate.publishThrottlingRateInByte, 0L);
                if (this.publishMaxMessageRate > 0) {
                    this.topicPublishRateLimiterOnMessage = RateLimiter.builder().scheduledExecutorService(this.scheduledExecutorService).permits(this.publishMaxMessageRate).rateLimitFunction(this::tryReleaseConnectionThrottle).isDispatchOrPrecisePublishRateLimiter(true).build();
                }
                if (this.publishMaxByteRate > 0L) {
                    this.topicPublishRateLimiterOnByte = RateLimiter.builder().scheduledExecutorService(this.scheduledExecutorService).permits(this.publishMaxByteRate).rateLimitFunction(this::tryReleaseConnectionThrottle).isDispatchOrPrecisePublishRateLimiter(true).build();
                }
            } else {
                this.publishMaxMessageRate = 0;
                this.publishMaxByteRate = 0L;
            }
        });
    }

    @Override
    public boolean tryAcquire(int numbers, long bytes) {
        RateLimiter currentTopicPublishRateLimiterOnMessage = this.topicPublishRateLimiterOnMessage;
        RateLimiter currentTopicPublishRateLimiterOnByte = this.topicPublishRateLimiterOnByte;
        return !(currentTopicPublishRateLimiterOnMessage != null && !currentTopicPublishRateLimiterOnMessage.tryAcquire(numbers) || currentTopicPublishRateLimiterOnByte != null && !currentTopicPublishRateLimiterOnByte.tryAcquire(bytes));
    }

    @Override
    public void close() throws Exception {
        this.rateLimitFunction.apply();
        this.replaceLimiters(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceLimiters(Runnable updater) {
        RateLimiter previousTopicPublishRateLimiterOnMessage = this.topicPublishRateLimiterOnMessage;
        this.topicPublishRateLimiterOnMessage = null;
        RateLimiter previousTopicPublishRateLimiterOnByte = this.topicPublishRateLimiterOnByte;
        this.topicPublishRateLimiterOnByte = null;
        try {
            if (updater != null) {
                updater.run();
            }
        }
        finally {
            if (previousTopicPublishRateLimiterOnMessage != null) {
                previousTopicPublishRateLimiterOnMessage.close();
            }
            if (previousTopicPublishRateLimiterOnByte != null) {
                previousTopicPublishRateLimiterOnByte.close();
            }
        }
    }
}

