/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.OneStageAuthenticationState;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.shade.javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;

public interface AuthenticationProvider
extends Closeable {
    public void initialize(ServiceConfiguration var1) throws IOException;

    public String getAuthMethodName();

    default public CompletableFuture<String> authenticateAsync(AuthenticationDataSource authData) {
        try {
            return CompletableFuture.completedFuture(this.authenticate(authData));
        }
        catch (AuthenticationException e) {
            return FutureUtil.failedFuture(e);
        }
    }

    @Deprecated
    default public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        throw new AuthenticationException("Not supported");
    }

    default public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
        return new OneStageAuthenticationState(authData, remoteAddress, sslSession, this);
    }

    @InterfaceStability.Unstable
    default public CompletableFuture<Boolean> authenticateHttpRequestAsync(HttpServletRequest request, HttpServletResponse response) {
        try {
            return CompletableFuture.completedFuture(this.authenticateHttpRequest(request, response));
        }
        catch (Exception e) {
            return FutureUtil.failedFuture(e);
        }
    }

    @Deprecated
    default public boolean authenticateHttpRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new AuthenticationException("Not supported");
    }
}

