/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import org.apache.pulsar.PulsarStandalone;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public final class PulsarStandaloneBuilder {
    private PulsarStandalone pulsarStandalone = new PulsarStandalone();

    private PulsarStandaloneBuilder() {
        this.pulsarStandalone.setWipeData(true);
        this.pulsarStandalone.setNoFunctionsWorker(true);
    }

    public static PulsarStandaloneBuilder instance() {
        return new PulsarStandaloneBuilder();
    }

    public PulsarStandaloneBuilder withConfig(ServiceConfiguration config) {
        this.pulsarStandalone.setConfig(config);
        return this;
    }

    public PulsarStandaloneBuilder withWipeData(boolean wipeData) {
        this.pulsarStandalone.setWipeData(wipeData);
        return this;
    }

    public PulsarStandaloneBuilder withNumOfBk(int numOfBk) {
        this.pulsarStandalone.setNumOfBk(numOfBk);
        return this;
    }

    public PulsarStandaloneBuilder withZkPort(int zkPort) {
        this.pulsarStandalone.setZkPort(zkPort);
        return this;
    }

    public PulsarStandaloneBuilder withBkPort(int bkPort) {
        this.pulsarStandalone.setBkPort(bkPort);
        return this;
    }

    public PulsarStandaloneBuilder withZkDir(String zkDir) {
        this.pulsarStandalone.setZkDir(zkDir);
        return this;
    }

    public PulsarStandaloneBuilder withBkDir(String bkDir) {
        this.pulsarStandalone.setBkDir(bkDir);
        return this;
    }

    public PulsarStandaloneBuilder withNoBroker(boolean noBroker) {
        this.pulsarStandalone.setNoBroker(noBroker);
        return this;
    }

    public PulsarStandaloneBuilder withOnlyBroker(boolean onlyBroker) {
        this.pulsarStandalone.setOnlyBroker(onlyBroker);
        return this;
    }

    public PulsarStandaloneBuilder withNoStreamStorage(boolean noStreamStorage) {
        this.pulsarStandalone.setNoStreamStorage(noStreamStorage);
        return this;
    }

    public PulsarStandaloneBuilder withStreamStoragePort(int streamStoragePort) {
        this.pulsarStandalone.setStreamStoragePort(streamStoragePort);
        return this;
    }

    public PulsarStandaloneBuilder withAdvertisedAddress(String advertisedAddress) {
        this.pulsarStandalone.setAdvertisedAddress(advertisedAddress);
        return this;
    }

    public PulsarStandalone build() {
        ServiceConfiguration config = new ServiceConfiguration();
        config.setClusterName("standalone");
        this.pulsarStandalone.setConfig(config);
        String zkServers = "127.0.0.1";
        if (this.pulsarStandalone.getAdvertisedAddress() != null) {
            this.pulsarStandalone.getConfig().setAdvertisedAddress(this.pulsarStandalone.getAdvertisedAddress());
            zkServers = this.pulsarStandalone.getAdvertisedAddress();
        } else if (StringUtils.isBlank(this.pulsarStandalone.getConfig().getAdvertisedAddress())) {
            this.pulsarStandalone.getConfig().setAdvertisedAddress(ServiceConfigurationUtils.unsafeLocalhostResolve());
        }
        this.pulsarStandalone.getConfig().setZookeeperServers(zkServers + ":" + this.pulsarStandalone.getZkPort());
        this.pulsarStandalone.getConfig().setConfigurationStoreServers(zkServers + ":" + this.pulsarStandalone.getZkPort());
        this.pulsarStandalone.getConfig().setRunningStandalone(true);
        return this.pulsarStandalone;
    }
}

