/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.nar;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    public static final long MILLIS_BETWEEN_ATTEMPTS = 50L;

    public static void ensureDirectoryExistAndCanReadAndWrite(File dir) throws IOException {
        boolean made;
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory");
        }
        if (!dir.exists() && !(made = dir.mkdirs())) {
            throw new IOException(dir.getAbsolutePath() + " could not be created");
        }
        if (!dir.canRead() || !dir.canWrite()) {
            throw new IOException(dir.getAbsolutePath() + " directory does not have read/write privilege");
        }
    }

    public static void ensureDirectoryExistAndCanRead(File dir) throws IOException {
        boolean made;
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory");
        }
        if (!dir.exists() && !(made = dir.mkdirs())) {
            throw new IOException(dir.getAbsolutePath() + " could not be created");
        }
        if (!dir.canRead()) {
            throw new IOException(dir.getAbsolutePath() + " directory does not have read privilege");
        }
    }

    public static boolean deleteFile(File file, Logger logger) {
        return FileUtils.deleteFile(file, logger, 1);
    }

    public static boolean deleteFile(File file, Logger logger, int attempts) {
        boolean isGone;
        block6: {
            if (file == null) {
                return false;
            }
            isGone = false;
            try {
                if (file.exists()) {
                    int effectiveAttempts = Math.max(1, attempts);
                    for (int i = 0; i < effectiveAttempts && !isGone; ++i) {
                        boolean bl = isGone = file.delete() || !file.exists();
                        if (isGone || effectiveAttempts - i <= 1) continue;
                        FileUtils.sleepQuietly(50L);
                    }
                    if (!isGone && logger != null) {
                        logger.warn("File appears to exist but unable to delete file: " + file.getAbsolutePath());
                    }
                }
            }
            catch (Throwable t) {
                if (logger == null) break block6;
                logger.warn("Unable to delete file: '" + file.getAbsolutePath() + "' due to " + t);
            }
        }
        return isGone;
    }

    public static void deleteFilesInDirectory(File directory, FilenameFilter filter, Logger logger) throws IOException {
        FileUtils.deleteFilesInDirectory(directory, filter, logger, false);
    }

    public static void deleteFilesInDirectory(File directory, FilenameFilter filter, Logger logger, boolean recurse) throws IOException {
        FileUtils.deleteFilesInDirectory(directory, filter, logger, recurse, false);
    }

    public static void deleteFilesInDirectory(File directory, FilenameFilter filter, Logger logger, boolean recurse, boolean deleteEmptyDirectories) throws IOException {
        if (null != directory && directory.isDirectory()) {
            File[] ingestFiles = directory.listFiles();
            if (ingestFiles == null) {
                throw new IOException("Unable to list directory content in: " + directory.getAbsolutePath());
            }
            for (File ingestFile : ingestFiles) {
                boolean process;
                boolean bl = process = filter == null ? true : filter.accept(directory, ingestFile.getName());
                if (ingestFile.isFile() && process) {
                    FileUtils.deleteFile(ingestFile, logger, 3);
                }
                if (!ingestFile.isDirectory() || !recurse) continue;
                FileUtils.deleteFilesInDirectory(ingestFile, filter, logger, recurse, deleteEmptyDirectories);
                String[] ingestFileList = ingestFile.list();
                if (!deleteEmptyDirectories || ingestFileList == null || ingestFileList.length != 0) continue;
                FileUtils.deleteFile(ingestFile, logger, 3);
            }
        }
    }

    public static void deleteFiles(Collection<File> files, boolean recurse) throws IOException {
        for (File file : files) {
            FileUtils.deleteFile(file, recurse);
        }
    }

    public static void deleteFile(File file, boolean recurse) throws IOException {
        File[] list = file.listFiles();
        if (file.isDirectory() && recurse && list != null) {
            FileUtils.deleteFiles(Arrays.asList(list), recurse);
        }
        if (!FileUtils.deleteFile(file, null, 5)) {
            throw new IOException("Unable to delete " + file.getAbsolutePath());
        }
    }

    public static void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean mayBeANarArchive(File jarFile) {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            ZipEntry entry = zipFile.getEntry("META-INF/bundled-dependencies");
            if (entry == null || !entry.isDirectory()) {
                log.info("Jar file {} does not contain META-INF/bundled-dependencies, it is not a NAR file", (Object)jarFile);
                boolean bl2 = false;
                return bl2;
            }
            log.info("Jar file {} contains META-INF/bundled-dependencies, it may be a NAR file", (Object)jarFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException err) {
            log.info("Cannot safely detect if {} is a NAR archive", (Object)jarFile, (Object)err);
            return true;
        }
    }
}

