/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.io.MoreFiles;
import org.apache.pulsar.shade.com.google.common.io.RecursiveDeleteOption;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;

public class FSCheckpointManager
implements CheckpointStore {
    private final File rootPath;

    public FSCheckpointManager(File rootPath) {
        this.rootPath = rootPath;
    }

    private File getFullyQualifiedPath(String filePath) {
        return new File(this.rootPath, filePath);
    }

    @Override
    public List<String> listFiles(String filePath) throws IOException {
        String[] files = this.getFullyQualifiedPath(filePath).list();
        if (null == files) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(files);
    }

    @Override
    public boolean fileExists(String filePath) throws IOException {
        return this.getFullyQualifiedPath(filePath).exists();
    }

    @Override
    public long getFileLength(String filePath) throws IOException {
        return this.getFullyQualifiedPath(filePath).length();
    }

    @Override
    public InputStream openInputStream(String filePath) throws IOException {
        return new FileInputStream(this.getFullyQualifiedPath(filePath));
    }

    @Override
    public OutputStream openOutputStream(String filePath) throws IOException {
        return new FileOutputStream(this.getFullyQualifiedPath(filePath));
    }

    @Override
    public void rename(String srcPath, String destPath) throws IOException {
        Files.move(Paths.get(this.getFullyQualifiedPath(srcPath).getAbsolutePath(), new String[0]), Paths.get(this.getFullyQualifiedPath(destPath).getAbsolutePath(), new String[0]), StandardCopyOption.ATOMIC_MOVE);
    }

    @Override
    public void deleteRecursively(String srcPath) throws IOException {
        MoreFiles.deleteRecursively(Paths.get(this.getFullyQualifiedPath(srcPath).getAbsolutePath(), new String[0]), RecursiveDeleteOption.ALLOW_INSECURE);
    }

    @Override
    public void delete(String srcPath) throws IOException {
        Files.delete(Paths.get(this.getFullyQualifiedPath(srcPath).getAbsolutePath(), new String[0]));
    }

    @Override
    public void createDirectories(String srcPath) throws IOException {
        Files.createDirectories(Paths.get(this.getFullyQualifiedPath(srcPath).getAbsolutePath(), new String[0]), new FileAttribute[0]);
    }

    @Override
    public void close() {
    }
}

