/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.google.common.hash.Hashing;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.pulsar.shade.org.apache.bookkeeper.statelib.impl.rocksdb.RocksUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.store.CheckpointMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.kv.store.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointFile {
    private static final Logger log = LoggerFactory.getLogger(CheckpointFile.class);
    private final File file;
    private final String checksum;
    private final boolean isSstFile;

    private CheckpointFile(File file, String checksum, boolean isSstFile) {
        this.file = file;
        this.checksum = checksum;
        this.isSstFile = isSstFile;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return String.format("CheckpointFile: %s", this.file.getName());
    }

    public boolean isSstFile() {
        return this.isSstFile;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getNameWithChecksum() {
        if (this.checksum != null) {
            return this.file.getName() + "_" + this.checksum;
        }
        return this.getName();
    }

    public String getRemoteSstPath(String dbPrefix, boolean enableChecksum) {
        if (enableChecksum) {
            return RocksUtils.getDestSstPath(dbPrefix, this.getNameWithChecksum());
        }
        return RocksUtils.getDestSstPath(dbPrefix, this.getName());
    }

    public String getRemotePath(String dbPrefix, String checkpointId, boolean enableChecksum) {
        if (this.isSstFile) {
            return this.getRemoteSstPath(dbPrefix, enableChecksum);
        }
        return RocksUtils.getDestPath(dbPrefix, checkpointId, this.file);
    }

    public static List<CheckpointFile> list(File checkpointedDir) {
        return Arrays.stream(checkpointedDir.listFiles()).map(f -> CheckpointFile.builder().file((File)f).computeChecksum().build()).collect(Collectors.toList());
    }

    public static List<CheckpointFile> list(File checkpointDir, CheckpointMetadata metadata) {
        if (metadata.getFileInfosCount() != 0) {
            return metadata.getFileInfosList().stream().map(f -> CheckpointFile.builder().file(checkpointDir, f.getName()).checksum(f.getChecksum()).build()).collect(Collectors.toList());
        }
        return metadata.getFilesList().stream().map(f -> CheckpointFile.builder().file(checkpointDir, (String)f).build()).collect(Collectors.toList());
    }

    public boolean needCopy(CheckpointStore checkpointStore, String dbPrefix, boolean enableChecksum) {
        if (!this.isSstFile) {
            return true;
        }
        String destSstPath = this.getRemoteSstPath(dbPrefix, enableChecksum);
        try {
            if (checkpointStore.fileExists(destSstPath)) {
                return false;
            }
        }
        catch (IOException e) {
            log.error("Failed fileExists {} {}", new Object[]{this.file.getName(), e.getMessage(), e});
        }
        return true;
    }

    public void copyToRemote(CheckpointStore checkpointStore, String dbPrefix, String checkpointId) throws IOException {
        String destPath = RocksUtils.getDestPath(dbPrefix, checkpointId, this.getName());
        try (OutputStream os = checkpointStore.openOutputStream(destPath);){
            org.apache.pulsar.shade.com.google.common.io.Files.copy(this.file, os);
        }
    }

    public void finalize(CheckpointStore checkpointStore, String dbPrefix, String checkpointId, boolean enableChecksum, boolean enableNonChecksumCompatibility) throws IOException {
        if (!RocksUtils.isSstFile(this.file)) {
            return;
        }
        String destSstTempPath = RocksUtils.getDestPath(dbPrefix, checkpointId, this.getName());
        String destSstPath = this.getRemoteSstPath(dbPrefix, enableChecksum);
        checkpointStore.rename(destSstTempPath, destSstPath);
        if (enableChecksum && enableNonChecksumCompatibility) {
            this.copyToRemoteWithoutChecksum(checkpointStore, dbPrefix, checkpointId);
        }
    }

    public void copyToRemoteWithoutChecksum(CheckpointStore checkpointStore, String dbPrefix, String checkpointId) throws IOException {
        String destPath = this.getRemoteSstPath(dbPrefix, false);
        try (OutputStream os = checkpointStore.openOutputStream(destPath);){
            org.apache.pulsar.shade.com.google.common.io.Files.copy(this.file, os);
        }
    }

    public void copyFromRemote(CheckpointStore checkpointStore, String dbPrefix, String checkpointId) throws IOException {
        String remoteFilePath = this.getRemotePath(dbPrefix, checkpointId, true);
        try (InputStream is = checkpointStore.openInputStream(remoteFilePath);){
            Files.copy(is, Paths.get(this.file.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public FileInfo getFileInfo() {
        return FileInfo.newBuilder().setName(this.file.getName()).setChecksum(this.checksum).build();
    }

    public static CheckpointFileBuilder builder() {
        return new CheckpointFileBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckpointFile)) {
            return false;
        }
        CheckpointFile other = (CheckpointFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSstFile() != other.isSstFile()) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$checksum = this.checksum;
        String other$checksum = other.checksum;
        return !(this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckpointFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSstFile() ? 79 : 97);
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $checksum = this.checksum;
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        return result;
    }

    public static class CheckpointFileBuilder {
        private File file;
        private String checksum;
        private boolean isSstFile;

        CheckpointFileBuilder file(File file) {
            this.file = file;
            this.isSstFile = RocksUtils.isSstFile(this.file);
            return this;
        }

        CheckpointFileBuilder file(File checkpointDir, String filename) {
            this.file(new File(checkpointDir, filename));
            return this;
        }

        CheckpointFileBuilder computeChecksum() {
            return this.checksum(CheckpointFileBuilder.computeChecksum(this.file));
        }

        private static String computeChecksum(File file) {
            String ckSum = "invalid-" + System.currentTimeMillis();
            try {
                ckSum = org.apache.pulsar.shade.com.google.common.io.Files.asByteSource(file).hash(Hashing.sha256()).toString();
                return ckSum;
            }
            catch (IOException e) {
                log.error("Failed to get checksum for file {} {}", new Object[]{file.getName(), e.getMessage(), e});
                return ckSum;
            }
        }

        CheckpointFileBuilder() {
        }

        public CheckpointFileBuilder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public CheckpointFileBuilder isSstFile(boolean isSstFile) {
            this.isSstFile = isSstFile;
            return this;
        }

        public CheckpointFile build() {
            return new CheckpointFile(this.file, this.checksum, this.isSstFile);
        }

        public String toString() {
            return "CheckpointFile.CheckpointFileBuilder(file=" + this.file + ", checksum=" + this.checksum + ", isSstFile=" + this.isSstFile + ")";
        }
    }
}

