/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.HttpServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.ErrorHttpService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.pulsar.shade.org.apache.bookkeeper.http.service.HttpServiceResponse;

public abstract class VertxAbstractHandler
implements Handler<RoutingContext> {
    void processRequest(HttpEndpointService httpEndpointService, RoutingContext context) {
        HttpServerRequest httpRequest = context.request();
        HttpServerResponse httpResponse = context.response();
        HttpServiceRequest request = new HttpServiceRequest().setMethod(this.convertMethod(httpRequest)).setParams(this.convertParams(httpRequest)).setBody(context.getBodyAsString());
        HttpServiceResponse response = null;
        try {
            response = httpEndpointService.handle(request);
        }
        catch (Exception e) {
            response = new ErrorHttpService().handle(request);
        }
        httpResponse.setStatusCode(response.getStatusCode());
        httpResponse.end(response.getBody());
    }

    Map<String, String> convertParams(HttpServerRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : request.params()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    HttpServer.Method convertMethod(HttpServerRequest request) {
        switch (request.method()) {
            case POST: {
                return HttpServer.Method.POST;
            }
            case DELETE: {
                return HttpServer.Method.DELETE;
            }
            case PUT: {
                return HttpServer.Method.PUT;
            }
        }
        return HttpServer.Method.GET;
    }
}

