/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.FloatCharHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;

public class FloatCharScatterMap
extends FloatCharHashMap {
    public FloatCharScatterMap() {
        this(4);
    }

    public FloatCharScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatCharScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatCharScatterMap from(float[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatCharScatterMap map = new FloatCharScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

