/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.metadata.api.CacheGetResult;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;

public class LocalPoliciesResources
extends BaseResources<LocalPolicies> {
    private static final String LOCAL_POLICIES_ROOT = "/admin/local-policies";

    public LocalPoliciesResources(MetadataStore localStore, int operationTimeoutSec) {
        super(localStore, LocalPolicies.class, operationTimeoutSec);
    }

    public void setLocalPolicies(NamespaceName ns, Function<LocalPolicies, LocalPolicies> modifyFunction) throws MetadataStoreException {
        this.set(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()), modifyFunction);
    }

    public Optional<LocalPolicies> getLocalPolicies(NamespaceName ns) throws MetadataStoreException {
        return this.get(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()));
    }

    public CompletableFuture<Optional<LocalPolicies>> getLocalPoliciesAsync(NamespaceName ns) {
        return this.getCache().get(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()));
    }

    public void setLocalPoliciesWithCreate(NamespaceName ns, Function<Optional<LocalPolicies>, LocalPolicies> createFunction) throws MetadataStoreException {
        this.setWithCreate(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()), createFunction);
    }

    public CompletableFuture<Void> createLocalPoliciesAsync(NamespaceName ns, LocalPolicies policies) {
        return this.getCache().create(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()), policies);
    }

    public CompletableFuture<Optional<CacheGetResult<LocalPolicies>>> getLocalPoliciesWithVersion(NamespaceName ns) {
        return this.getCache().getWithStats(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()));
    }

    public CompletableFuture<Void> setLocalPoliciesWithVersion(NamespaceName ns, LocalPolicies policies, Optional<Long> version) {
        try {
            byte[] content = ObjectMapperFactory.getThreadLocal().writeValueAsBytes(policies);
            return this.getStore().put(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()), content, version).thenApply(__ -> null);
        }
        catch (JsonProcessingException e) {
            return FutureUtil.failedFuture(e);
        }
    }

    public void deleteLocalPolicies(NamespaceName ns) throws MetadataStoreException {
        this.delete(LocalPoliciesResources.joinPath(LOCAL_POLICIES_ROOT, ns.toString()));
    }

    public static boolean isLocalPoliciesPath(String path) {
        return path.startsWith(LOCAL_POLICIES_ROOT);
    }
}

