/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationProviderList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationService
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationService.class);
    private final String anonymousUserRole;
    private final Map<String, AuthenticationProvider> providers = Maps.newHashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthenticationService(ServiceConfiguration conf) throws PulsarServerException {
        this.anonymousUserRole = conf.getAnonymousUserRole();
        if (conf.isAuthenticationEnabled()) {
            try {
                AuthenticationProvider provider;
                HashMap<String, ArrayList<AuthenticationProvider>> providerMap = new HashMap<String, ArrayList<AuthenticationProvider>>();
                for (String string : conf.getAuthenticationProviders()) {
                    if (string.isEmpty()) continue;
                    provider = (AuthenticationProvider)Class.forName(string).newInstance();
                    ArrayList<AuthenticationProvider> providerList = (ArrayList<AuthenticationProvider>)providerMap.get(provider.getAuthMethodName());
                    if (null == providerList) {
                        providerList = new ArrayList<AuthenticationProvider>(1);
                        providerMap.put(provider.getAuthMethodName(), providerList);
                    }
                    providerList.add(provider);
                }
                for (Map.Entry entry : providerMap.entrySet()) {
                    provider = new AuthenticationProviderList((List)entry.getValue());
                    ((AuthenticationProviderList)provider).initialize(conf);
                    this.providers.put(((AuthenticationProviderList)provider).getAuthMethodName(), provider);
                    LOG.info("[{}] has been loaded.", (Object)((List)entry.getValue()).stream().map(p -> p.getClass().getName()).collect(Collectors.joining(",")));
                }
                if (!this.providers.isEmpty()) return;
                LOG.warn("No authentication providers are loaded.");
                return;
            }
            catch (Throwable e) {
                throw new PulsarServerException("Failed to load an authentication provider.", e);
            }
        } else {
            LOG.info("Authentication is disabled");
        }
    }

    public String authenticate(AuthenticationDataSource authData, String authMethodName) throws AuthenticationException {
        AuthenticationProvider provider = this.providers.get(authMethodName);
        if (provider != null) {
            return provider.authenticate(authData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.anonymousUserRole)) {
            return this.anonymousUserRole;
        }
        throw new AuthenticationException("Unsupported authentication mode: " + authMethodName);
    }

    public String authenticateHttpRequest(HttpServletRequest request) throws AuthenticationException {
        AuthenticationException authenticationException = null;
        AuthenticationDataHttps authData = new AuthenticationDataHttps(request);
        String authMethodName = request.getHeader("X-Pulsar-Auth-Method-Name");
        if (authMethodName != null) {
            AuthenticationProvider providerToUse = this.providers.get(authMethodName);
            if (providerToUse == null) {
                throw new AuthenticationException(String.format("Unsupported authentication method: [%s].", authMethodName));
            }
            try {
                return providerToUse.authenticate(authData);
            }
            catch (AuthenticationException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed for provider " + providerToUse.getAuthMethodName() + ": " + e.getMessage(), (Throwable)e);
                }
                authenticationException = e;
                throw e;
            }
        }
        for (AuthenticationProvider provider : this.providers.values()) {
            try {
                return provider.authenticate(authData);
            }
            catch (AuthenticationException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Authentication failed for provider " + provider.getAuthMethodName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (!this.providers.isEmpty()) {
            if (StringUtils.isNotBlank((CharSequence)this.anonymousUserRole)) {
                return this.anonymousUserRole;
            }
            if (authenticationException != null) {
                throw authenticationException;
            }
            throw new AuthenticationException("Authentication required");
        }
        return "<none>";
    }

    public AuthenticationProvider getAuthenticationProvider(String authMethodName) {
        return this.providers.get(authMethodName);
    }

    public Optional<String> getAnonymousUserRole() {
        if (StringUtils.isNotBlank((CharSequence)this.anonymousUserRole)) {
            return Optional.of(this.anonymousUserRole);
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        for (AuthenticationProvider provider : this.providers.values()) {
            provider.close();
        }
    }
}

