/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.LocalPolicies;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.policies.path.PolicyPath;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;

public class NamespaceResources
extends BaseResources<Policies> {
    private final IsolationPolicyResources isolationPolicies;
    private final PartitionedTopicResources partitionedTopicResources;
    private final MetadataStore configurationStore;
    private final MetadataCache<LocalPolicies> localPoliciesCache;
    private static final String LOCAL_POLICIES_ROOT = "/admin/local-policies";

    public NamespaceResources(MetadataStore localStore, MetadataStore configurationStore, int operationTimeoutSec) {
        super(configurationStore, Policies.class, operationTimeoutSec);
        this.configurationStore = configurationStore;
        this.isolationPolicies = new IsolationPolicyResources(configurationStore, operationTimeoutSec);
        this.partitionedTopicResources = new PartitionedTopicResources(configurationStore, operationTimeoutSec);
        this.localPoliciesCache = localStore != null ? localStore.getMetadataCache(LocalPolicies.class) : null;
    }

    public CompletableFuture<Optional<Policies>> getPolicies(NamespaceName ns) {
        return this.getCache().get(PolicyPath.path((String[])new String[]{"policies", ns.toString()}));
    }

    public CompletableFuture<Optional<LocalPolicies>> getLocalPolicies(NamespaceName ns) {
        if (this.localPoliciesCache == null) {
            return FutureUtil.failedFuture((Throwable)new IllegalStateException("Local metadata store not setup"));
        }
        return this.localPoliciesCache.get(PolicyPath.joinPath((String[])new String[]{LOCAL_POLICIES_ROOT, ns.toString()}));
    }

    public IsolationPolicyResources getIsolationPolicies() {
        return this.isolationPolicies;
    }

    public PartitionedTopicResources getPartitionedTopicResources() {
        return this.partitionedTopicResources;
    }

    public MetadataStore getConfigurationStore() {
        return this.configurationStore;
    }

    public MetadataCache<LocalPolicies> getLocalPoliciesCache() {
        return this.localPoliciesCache;
    }

    public static class PartitionedTopicResources
    extends BaseResources<PartitionedTopicMetadata> {
        public PartitionedTopicResources(MetadataStore configurationStore, int operationTimeoutSec) {
            super(configurationStore, PartitionedTopicMetadata.class, operationTimeoutSec);
        }
    }

    public static class IsolationPolicyResources
    extends BaseResources<Map<String, NamespaceIsolationDataImpl>> {
        public IsolationPolicyResources(MetadataStore store, int operationTimeoutSec) {
            super(store, new TypeReference<Map<String, NamespaceIsolationDataImpl>>(){}, operationTimeoutSec);
        }

        public Optional<NamespaceIsolationPolicies> getPolicies(String path) throws MetadataStoreException {
            Optional data = super.get(path);
            return data.isPresent() ? Optional.of(new NamespaceIsolationPolicies((Map)data.get())) : Optional.empty();
        }
    }
}

