/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;

public class NamespaceResources
extends BaseResources<Policies> {
    private IsolationPolicyResources isolationPolicies;
    private PartitionedTopicResources partitionedTopicResources;
    private MetadataStoreExtended configurationStore;

    public NamespaceResources(MetadataStoreExtended configurationStore, int operationTimeoutSec) {
        super(configurationStore, Policies.class, operationTimeoutSec);
        this.configurationStore = configurationStore;
        this.isolationPolicies = new IsolationPolicyResources(configurationStore, operationTimeoutSec);
        this.partitionedTopicResources = new PartitionedTopicResources(configurationStore, operationTimeoutSec);
    }

    public IsolationPolicyResources getIsolationPolicies() {
        return this.isolationPolicies;
    }

    public PartitionedTopicResources getPartitionedTopicResources() {
        return this.partitionedTopicResources;
    }

    public MetadataStoreExtended getConfigurationStore() {
        return this.configurationStore;
    }

    public static class PartitionedTopicResources
    extends BaseResources<PartitionedTopicMetadata> {
        public PartitionedTopicResources(MetadataStoreExtended configurationStore, int operationTimeoutSec) {
            super(configurationStore, PartitionedTopicMetadata.class, operationTimeoutSec);
        }
    }

    public static class IsolationPolicyResources
    extends BaseResources<Map<String, NamespaceIsolationData>> {
        public IsolationPolicyResources(MetadataStoreExtended store, int operationTimeoutSec) {
            super(store, new TypeReference<Map<String, NamespaceIsolationData>>(){}, operationTimeoutSec);
        }

        public Optional<NamespaceIsolationPolicies> getPolicies(String path) throws MetadataStoreException {
            Optional data = super.get(path);
            return data.isPresent() ? Optional.of(new NamespaceIsolationPolicies((Map)data.get())) : Optional.empty();
        }
    }
}

