/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.net.SocketAddress;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationDataCommand
implements AuthenticationDataSource {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationDataCommand.class);
    protected final String authData;
    protected final SocketAddress remoteAddress;
    protected final SSLSession sslSession;
    protected String subscription;

    public AuthenticationDataCommand(String authData) {
        this(authData, null, null, null);
    }

    public AuthenticationDataCommand(String authData, String subscription) {
        this(authData, null, null, subscription);
    }

    public AuthenticationDataCommand(String authData, SocketAddress remoteAddress, SSLSession sslSession, String subscription) {
        this.authData = authData;
        this.remoteAddress = remoteAddress;
        this.sslSession = sslSession;
        this.subscription = subscription;
    }

    public AuthenticationDataCommand(String authData, SocketAddress remoteAddress, SSLSession sslSession) {
        this.authData = authData;
        this.remoteAddress = remoteAddress;
        this.sslSession = sslSession;
    }

    @Override
    public boolean hasDataFromCommand() {
        return this.authData != null;
    }

    @Override
    public String getCommandData() {
        return this.authData;
    }

    @Override
    public boolean hasDataFromPeer() {
        return this.remoteAddress != null;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.remoteAddress;
    }

    @Override
    public boolean hasDataFromTls() {
        return this.sslSession != null;
    }

    @Override
    public Certificate[] getTlsCertificates() {
        try {
            return this.sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            log.error("Failed to verify the peer's identity", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean hasSubscription() {
        return this.subscription != null;
    }

    @Override
    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    @Override
    public String getSubscription() {
        return this.subscription;
    }
}

