/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    private AuthorizationProvider provider;
    private final ServiceConfiguration conf;

    public AuthorizationService(ServiceConfiguration conf, ConfigurationCacheService configCache) throws PulsarServerException {
        this.conf = conf;
        try {
            String providerClassname = conf.getAuthorizationProvider();
            if (!StringUtils.isNotBlank((CharSequence)providerClassname)) {
                throw new PulsarServerException("No authorization providers are present.");
            }
            this.provider = (AuthorizationProvider)Class.forName(providerClassname).newInstance();
            this.provider.initialize(conf, configCache);
            log.info("{} has been loaded.", (Object)providerClassname);
        }
        catch (PulsarServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PulsarServerException("Failed to load an authorization provider.", e);
        }
    }

    public CompletableFuture<Boolean> isSuperUser(String user, AuthenticationDataSource authenticationData) {
        if (this.provider != null) {
            return this.provider.isSuperUser(user, authenticationData, this.conf);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
        if (this.provider != null) {
            return this.provider.isTenantAdmin(tenant, role, tenantInfo, authenticationData);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authDataJson) {
        if (this.provider != null) {
            return this.provider.grantPermissionAsync(namespace, actions, role, authDataJson);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
        if (this.provider != null) {
            return this.provider.grantSubscriptionPermissionAsync(namespace, subscriptionName, roles, authDataJson);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
        if (this.provider != null) {
            return this.provider.revokeSubscriptionPermissionAsync(namespace, subscriptionName, role, authDataJson);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Void> grantPermissionAsync(TopicName topicname, Set<AuthAction> actions, String role, String authDataJson) {
        if (this.provider != null) {
            return this.provider.grantPermissionAsync(topicname, actions, role, authDataJson);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (this.provider != null) {
            return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
                if (isSuperUser.booleanValue()) {
                    return CompletableFuture.completedFuture(true);
                }
                return this.provider.canProduceAsync(topicName, role, authenticationData);
            });
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (this.provider != null) {
            return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
                if (isSuperUser.booleanValue()) {
                    return CompletableFuture.completedFuture(true);
                }
                return this.provider.canConsumeAsync(topicName, role, authenticationData, subscription);
            });
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured"));
    }

    public boolean canProduce(TopicName topicName, String role, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return this.canProduceAsync(topicName, role, authenticationData).get(this.conf.getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getZooKeeperOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Producer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public boolean canConsume(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) throws Exception {
        try {
            return this.canConsumeAsync(topicName, role, authenticationData, subscription).get(this.conf.getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getZooKeeperOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Consumer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public boolean canLookup(TopicName topicName, String role, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return this.canLookupAsync(topicName, role, authenticationData).get(this.conf.getZooKeeperOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getZooKeeperOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Role - {} failed to get lookup permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        CompletableFuture<Boolean> finalResult = new CompletableFuture<Boolean>();
        this.canProduceAsync(topicName, role, authenticationData).whenComplete((produceAuthorized, ex) -> {
            if (ex == null) {
                if (produceAuthorized.booleanValue()) {
                    finalResult.complete((Boolean)produceAuthorized);
                    return;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Topic [{}] Role [{}] exception occurred while trying to check Produce permissions. {}", new Object[]{topicName.toString(), role, ex.getMessage()});
            }
            this.canConsumeAsync(topicName, role, authenticationData, null).whenComplete((consumeAuthorized, e) -> {
                if (e == null) {
                    if (consumeAuthorized.booleanValue()) {
                        finalResult.complete((Boolean)consumeAuthorized);
                        return;
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Topic [{}] Role [{}] exception occurred while trying to check Consume permissions. {}", new Object[]{topicName.toString(), role, e.getMessage()});
                    }
                    finalResult.completeExceptionally((Throwable)e);
                    return;
                }
                finalResult.complete(false);
            });
        });
        return finalResult;
    }

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.provider.allowFunctionOpsAsync(namespaceName, role, authenticationData);
    }

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.provider.allowSourceOpsAsync(namespaceName, role, authenticationData);
    }

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.provider.allowSinkOpsAsync(namespaceName, role, authenticationData);
    }

    private static void validateOriginalPrincipal(Set<String> proxyRoles, String authenticatedPrincipal, String originalPrincipal) {
        if (proxyRoles.contains(authenticatedPrincipal)) {
            if (StringUtils.isBlank((CharSequence)originalPrincipal)) {
                log.warn("Original principal empty in request authenticated as {}", (Object)authenticatedPrincipal);
                throw new RestException(Response.Status.UNAUTHORIZED, "Original principal cannot be empty if the request is via proxy.");
            }
            if (proxyRoles.contains(originalPrincipal)) {
                log.warn("Original principal {} cannot be a proxy role ({})", (Object)originalPrincipal, proxyRoles);
                throw new RestException(Response.Status.UNAUTHORIZED, "Original principal cannot be a proxy role");
            }
        }
    }

    private boolean isProxyRole(String role) {
        return role != null && this.conf.getProxyRoles().contains(role);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, TenantOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (this.provider != null) {
            return this.provider.allowTenantOperationAsync(tenantName, role, operation, authData);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured for allowTenantOperationAsync"));
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, TenantOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTenantOperationAsync(tenantName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTenantOperationAsync(tenantName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTenantOperationAsync(tenantName, operation, role, authData);
    }

    public boolean allowTenantOperation(String tenantName, TenantOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        try {
            return this.allowTenantOperationAsync(tenantName, operation, originalRole, role, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, NamespaceOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (this.provider != null) {
            return this.provider.allowNamespaceOperationAsync(namespaceName, role, operation, authData);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured for allowNamespaceOperationAsync"));
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, NamespaceOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowNamespaceOperationAsync(namespaceName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowNamespaceOperationAsync(namespaceName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowNamespaceOperationAsync(namespaceName, operation, role, authData);
    }

    public boolean allowNamespaceOperation(NamespaceName namespaceName, NamespaceOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        try {
            return this.allowNamespaceOperationAsync(namespaceName, operation, originalRole, role, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (this.provider != null) {
            return this.provider.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured for allowNamespacePolicyOperationAsync"));
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        AuthorizationService.validateOriginalPrincipal(this.conf.getProxyRoles(), role, originalRole);
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
    }

    public boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        try {
            return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, role, authData).get();
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, TopicOperation operation, String role, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check if role {} is allowed to execute topic operation {} on topic {}", new Object[]{role, operation, topicName});
        }
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        if (this.provider != null) {
            CompletableFuture<Boolean> allowFuture = this.provider.allowTopicOperationAsync(topicName, role, operation, authData);
            if (log.isDebugEnabled()) {
                return allowFuture.whenComplete((allowed, exception) -> {
                    if (exception == null) {
                        if (allowed.booleanValue()) {
                            log.debug("Topic operation {} on topic {} is allowed: role = {}", new Object[]{operation, topicName, role});
                        } else {
                            log.debug("Topic operation {} on topic {} is NOT allowed: role = {}", new Object[]{operation, topicName, role});
                        }
                    } else {
                        log.debug("Failed to check if topic operation {} on topic {} is allowed: role = {}", new Object[]{operation, topicName, role, exception});
                    }
                });
            }
            return allowFuture;
        }
        return FutureUtil.failedFuture((Throwable)new IllegalStateException("No authorization provider configured for allowTopicOperationAsync"));
    }
}

