/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;

public class AuthenticationDataHttp
implements AuthenticationDataSource {
    protected final HttpServletRequest request;
    protected final SocketAddress remoteAddress;

    public AuthenticationDataHttp(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        this.request = request;
        this.remoteAddress = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
    }

    @Override
    public boolean hasDataFromHttp() {
        return true;
    }

    @Override
    public String getHttpAuthType() {
        return this.request.getAuthType();
    }

    @Override
    public String getHttpHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public boolean hasDataFromPeer() {
        return true;
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.remoteAddress;
    }
}

