/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.SignatureException;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.List;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataCommand;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.common.api.AuthData;

public class AuthenticationProviderToken
implements AuthenticationProvider {
    static final String HTTP_HEADER_NAME = "Authorization";
    static final String HTTP_HEADER_VALUE_PREFIX = "Bearer ";
    static final String CONF_TOKEN_SETTING_PREFIX = "";
    static final String CONF_TOKEN_SECRET_KEY = "tokenSecretKey";
    static final String CONF_TOKEN_PUBLIC_KEY = "tokenPublicKey";
    static final String CONF_TOKEN_AUTH_CLAIM = "tokenAuthClaim";
    static final String CONF_TOKEN_PUBLIC_ALG = "tokenPublicAlg";
    static final String CONF_TOKEN_AUDIENCE_CLAIM = "tokenAudienceClaim";
    static final String CONF_TOKEN_AUDIENCE = "tokenAudience";
    static final String TOKEN = "token";
    private static final Counter expiredTokenMetrics = (Counter)((Counter.Builder)((Counter.Builder)Counter.build().name("pulsar_expired_token_count")).help("Pulsar expired token")).register();
    private static final Histogram expiringTokenMinutesMetrics = (Histogram)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("pulsar_expiring_token_minutes")).help("The remaining time of expiring token in minutes")).buckets(new double[]{5.0, 10.0, 60.0, 240.0}).register();
    private Key validationKey;
    private String roleClaim;
    private SignatureAlgorithm publicKeyAlg;
    private String audienceClaim;
    private String audience;
    private String confTokenSecretKeySettingName;
    private String confTokenPublicKeySettingName;
    private String confTokenAuthClaimSettingName;
    private String confTokenPublicAlgSettingName;
    private String confTokenAudienceClaimSettingName;
    private String confTokenAudienceSettingName;

    @Override
    public void close() throws IOException {
    }

    @Override
    public void initialize(ServiceConfiguration config) throws IOException, IllegalArgumentException {
        String prefix = (String)config.getProperty(CONF_TOKEN_SETTING_PREFIX);
        if (null == prefix) {
            prefix = CONF_TOKEN_SETTING_PREFIX;
        }
        this.confTokenSecretKeySettingName = prefix + CONF_TOKEN_SECRET_KEY;
        this.confTokenPublicKeySettingName = prefix + CONF_TOKEN_PUBLIC_KEY;
        this.confTokenAuthClaimSettingName = prefix + CONF_TOKEN_AUTH_CLAIM;
        this.confTokenPublicAlgSettingName = prefix + CONF_TOKEN_PUBLIC_ALG;
        this.confTokenAudienceClaimSettingName = prefix + CONF_TOKEN_AUDIENCE_CLAIM;
        this.confTokenAudienceSettingName = prefix + CONF_TOKEN_AUDIENCE;
        this.publicKeyAlg = this.getPublicKeyAlgType(config);
        this.validationKey = this.getValidationKey(config);
        this.roleClaim = this.getTokenRoleClaim(config);
        this.audienceClaim = this.getTokenAudienceClaim(config);
        this.audience = this.getTokenAudience(config);
        if (this.audienceClaim != null && this.audience == null) {
            throw new IllegalArgumentException("Token Audience Claim [" + this.audienceClaim + "] configured, but Audience stands for this broker not.");
        }
    }

    @Override
    public String getAuthMethodName() {
        return TOKEN;
    }

    @Override
    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        try {
            String token = AuthenticationProviderToken.getToken(authData);
            String role = this.getPrincipal(this.authenticateToken(token));
            AuthenticationMetrics.authenticateSuccess(this.getClass().getSimpleName(), this.getAuthMethodName());
            return role;
        }
        catch (AuthenticationException exception) {
            AuthenticationMetrics.authenticateFailure(this.getClass().getSimpleName(), this.getAuthMethodName(), exception.getMessage());
            throw exception;
        }
    }

    @Override
    public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
        return new TokenAuthenticationState(this, authData, remoteAddress, sslSession);
    }

    public static String getToken(AuthenticationDataSource authData) throws AuthenticationException {
        if (authData.hasDataFromCommand()) {
            return AuthenticationProviderToken.validateToken(authData.getCommandData());
        }
        if (authData.hasDataFromHttp()) {
            String httpHeaderValue = authData.getHttpHeader(HTTP_HEADER_NAME);
            if (httpHeaderValue == null || !httpHeaderValue.startsWith(HTTP_HEADER_VALUE_PREFIX)) {
                throw new AuthenticationException("Invalid HTTP Authorization header");
            }
            String token = httpHeaderValue.substring(HTTP_HEADER_VALUE_PREFIX.length());
            return AuthenticationProviderToken.validateToken(token);
        }
        throw new AuthenticationException("No token credentials passed");
    }

    private static String validateToken(String token) throws AuthenticationException {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        throw new AuthenticationException("Blank token found");
    }

    private Jwt<?, Claims> authenticateToken(String token) throws AuthenticationException {
        try {
            Jws jwt = Jwts.parserBuilder().setSigningKey(this.validationKey).build().parseClaimsJws(token);
            if (this.audienceClaim != null) {
                Object object = ((Claims)jwt.getBody()).get((Object)this.audienceClaim);
                if (object == null) {
                    throw new JwtException("Found null Audience in token, for claimed field: " + this.audienceClaim);
                }
                if (object instanceof List) {
                    List audiences = (List)object;
                    if (!audiences.stream().anyMatch(audienceInToken -> audienceInToken.equals(this.audience))) {
                        throw new AuthenticationException("Audiences in token: [" + String.join((CharSequence)", ", audiences) + "] not contains this broker: " + this.audience);
                    }
                } else if (object instanceof String) {
                    if (!object.equals(this.audience)) {
                        throw new AuthenticationException("Audiences in token: [" + object + "] not contains this broker: " + this.audience);
                    }
                } else {
                    throw new AuthenticationException("Audiences in token is not in expected format: " + object);
                }
            }
            if (((Claims)jwt.getBody()).getExpiration() != null) {
                expiringTokenMinutesMetrics.observe((double)(((Claims)jwt.getBody()).getExpiration().getTime() - new Date().getTime()) / 60000.0);
            }
            return jwt;
        }
        catch (JwtException e) {
            if (e instanceof ExpiredJwtException) {
                expiredTokenMetrics.inc();
            }
            throw new AuthenticationException("Failed to authentication token: " + e.getMessage());
        }
    }

    private String getPrincipal(Jwt<?, Claims> jwt) {
        return (String)((Claims)jwt.getBody()).get(this.roleClaim, String.class);
    }

    private Key getValidationKey(ServiceConfiguration conf) throws IOException {
        if (conf.getProperty(this.confTokenSecretKeySettingName) != null && StringUtils.isNotBlank((CharSequence)((String)conf.getProperty(this.confTokenSecretKeySettingName)))) {
            String validationKeyConfig = (String)conf.getProperty(this.confTokenSecretKeySettingName);
            byte[] validationKey = AuthTokenUtils.readKeyFromUrl(validationKeyConfig);
            return AuthTokenUtils.decodeSecretKey(validationKey);
        }
        if (conf.getProperty(this.confTokenPublicKeySettingName) != null && StringUtils.isNotBlank((CharSequence)((String)conf.getProperty(this.confTokenPublicKeySettingName)))) {
            String validationKeyConfig = (String)conf.getProperty(this.confTokenPublicKeySettingName);
            byte[] validationKey = AuthTokenUtils.readKeyFromUrl(validationKeyConfig);
            return AuthTokenUtils.decodePublicKey(validationKey, this.publicKeyAlg);
        }
        throw new IOException("No secret key was provided for token authentication");
    }

    private String getTokenRoleClaim(ServiceConfiguration conf) throws IOException {
        if (conf.getProperty(this.confTokenAuthClaimSettingName) != null && StringUtils.isNotBlank((CharSequence)((String)conf.getProperty(this.confTokenAuthClaimSettingName)))) {
            return (String)conf.getProperty(this.confTokenAuthClaimSettingName);
        }
        return "sub";
    }

    private SignatureAlgorithm getPublicKeyAlgType(ServiceConfiguration conf) throws IllegalArgumentException {
        if (conf.getProperty(this.confTokenPublicAlgSettingName) != null && StringUtils.isNotBlank((CharSequence)((String)conf.getProperty(this.confTokenPublicAlgSettingName)))) {
            String alg = (String)conf.getProperty(this.confTokenPublicAlgSettingName);
            try {
                return SignatureAlgorithm.forName((String)alg);
            }
            catch (SignatureException ex) {
                throw new IllegalArgumentException("invalid algorithm provided " + alg, ex);
            }
        }
        return SignatureAlgorithm.RS256;
    }

    private String getTokenAudienceClaim(ServiceConfiguration conf) throws IllegalArgumentException {
        if (conf.getProperty(this.confTokenAudienceClaimSettingName) != null && StringUtils.isNotBlank((CharSequence)((String)conf.getProperty(this.confTokenAudienceClaimSettingName)))) {
            return (String)conf.getProperty(this.confTokenAudienceClaimSettingName);
        }
        return null;
    }

    private String getTokenAudience(ServiceConfiguration conf) throws IllegalArgumentException {
        if (conf.getProperty(this.confTokenAudienceSettingName) != null && StringUtils.isNotBlank((CharSequence)((String)conf.getProperty(this.confTokenAudienceSettingName)))) {
            return (String)conf.getProperty(this.confTokenAudienceSettingName);
        }
        return null;
    }

    private static final class TokenAuthenticationState
    implements AuthenticationState {
        private final AuthenticationProviderToken provider;
        private AuthenticationDataSource authenticationDataSource;
        private Jwt<?, Claims> jwt;
        private final SocketAddress remoteAddress;
        private final SSLSession sslSession;
        private long expiration;

        TokenAuthenticationState(AuthenticationProviderToken provider, AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
            this.provider = provider;
            this.remoteAddress = remoteAddress;
            this.sslSession = sslSession;
            this.authenticate(authData);
        }

        @Override
        public String getAuthRole() throws AuthenticationException {
            return this.provider.getPrincipal(this.jwt);
        }

        @Override
        public AuthData authenticate(AuthData authData) throws AuthenticationException {
            String token = new String(authData.getBytes(), StandardCharsets.UTF_8);
            this.jwt = this.provider.authenticateToken(token);
            this.authenticationDataSource = new AuthenticationDataCommand(token, this.remoteAddress, this.sslSession);
            this.expiration = ((Claims)this.jwt.getBody()).getExpiration() != null ? ((Claims)this.jwt.getBody()).getExpiration().getTime() : Long.MAX_VALUE;
            return null;
        }

        @Override
        public AuthenticationDataSource getAuthDataSource() {
            return this.authenticationDataSource;
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public boolean isExpired() {
            return this.expiration < System.currentTimeMillis();
        }
    }
}

