/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceConfigurationUtils.class);

    public static String getDefaultOrConfiguredAddress(String configuredAddress) {
        if (StringUtils.isBlank((CharSequence)configuredAddress)) {
            return ServiceConfigurationUtils.unsafeLocalhostResolve();
        }
        return configuredAddress;
    }

    public static String unsafeLocalhostResolve() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new IllegalStateException("Failed to resolve localhost name.", ex);
        }
    }
}

