/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;

public class AuthenticationProviderTls
implements AuthenticationProvider {
    @Override
    public void close() throws IOException {
    }

    @Override
    public void initialize(ServiceConfiguration config) throws IOException {
    }

    @Override
    public String getAuthMethodName() {
        return "tls";
    }

    @Override
    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        String commonName = null;
        try {
            if (authData.hasDataFromTls()) {
                Certificate[] certs = authData.getTlsCertificates();
                if (null == certs) {
                    throw new AuthenticationException("Failed to get TLS certificates from client");
                }
                String distinguishedName = ((X509Certificate)certs[0]).getSubjectX500Principal().getName();
                for (String keyValueStr : distinguishedName.split(",")) {
                    String[] keyValue = keyValueStr.split("=", 2);
                    if (keyValue.length != 2 || !"CN".equals(keyValue[0]) || keyValue[1].isEmpty()) continue;
                    commonName = keyValue[1];
                    break;
                }
            }
            if (commonName == null) {
                throw new AuthenticationException("Client unable to authenticate with TLS certificate");
            }
            AuthenticationMetrics.authenticateSuccess(this.getClass().getSimpleName(), this.getAuthMethodName());
        }
        catch (AuthenticationException exception) {
            AuthenticationMetrics.authenticateFailure(this.getClass().getSimpleName(), this.getAuthMethodName(), exception.getMessage());
            throw exception;
        }
        return commonName;
    }
}

