package io.streamnative.oxia.proto;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * Oxia service that allows clients to discover shard-to-server assignments and
 * submit batches of requests.
 * Clients should connect to a random server to discover the shard-to-server
 * assignments and then send the actual batched requests to the appropriate
 * shard leader. In the future, this may be handled server-side in a proxy
 * layer to allows clients to not be concerned with sharding.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.55.3)",
    comments = "Source: io/streamnative/oxia/client.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class OxiaClientGrpc {

  private OxiaClientGrpc() {}

  public static final String SERVICE_NAME = "io.streamnative.oxia.proto.OxiaClient";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ShardAssignmentsRequest,
      io.streamnative.oxia.proto.ShardAssignments> getGetShardAssignmentsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetShardAssignments",
      requestType = io.streamnative.oxia.proto.ShardAssignmentsRequest.class,
      responseType = io.streamnative.oxia.proto.ShardAssignments.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ShardAssignmentsRequest,
      io.streamnative.oxia.proto.ShardAssignments> getGetShardAssignmentsMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ShardAssignmentsRequest, io.streamnative.oxia.proto.ShardAssignments> getGetShardAssignmentsMethod;
    if ((getGetShardAssignmentsMethod = OxiaClientGrpc.getGetShardAssignmentsMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getGetShardAssignmentsMethod = OxiaClientGrpc.getGetShardAssignmentsMethod) == null) {
          OxiaClientGrpc.getGetShardAssignmentsMethod = getGetShardAssignmentsMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.ShardAssignmentsRequest, io.streamnative.oxia.proto.ShardAssignments>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetShardAssignments"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.ShardAssignmentsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.ShardAssignments.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("GetShardAssignments"))
              .build();
        }
      }
    }
    return getGetShardAssignmentsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.WriteRequest,
      io.streamnative.oxia.proto.WriteResponse> getWriteMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Write",
      requestType = io.streamnative.oxia.proto.WriteRequest.class,
      responseType = io.streamnative.oxia.proto.WriteResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.WriteRequest,
      io.streamnative.oxia.proto.WriteResponse> getWriteMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.WriteRequest, io.streamnative.oxia.proto.WriteResponse> getWriteMethod;
    if ((getWriteMethod = OxiaClientGrpc.getWriteMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getWriteMethod = OxiaClientGrpc.getWriteMethod) == null) {
          OxiaClientGrpc.getWriteMethod = getWriteMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.WriteRequest, io.streamnative.oxia.proto.WriteResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Write"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.WriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.WriteResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("Write"))
              .build();
        }
      }
    }
    return getWriteMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.WriteRequest,
      io.streamnative.oxia.proto.WriteResponse> getWriteStreamMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "WriteStream",
      requestType = io.streamnative.oxia.proto.WriteRequest.class,
      responseType = io.streamnative.oxia.proto.WriteResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.WriteRequest,
      io.streamnative.oxia.proto.WriteResponse> getWriteStreamMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.WriteRequest, io.streamnative.oxia.proto.WriteResponse> getWriteStreamMethod;
    if ((getWriteStreamMethod = OxiaClientGrpc.getWriteStreamMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getWriteStreamMethod = OxiaClientGrpc.getWriteStreamMethod) == null) {
          OxiaClientGrpc.getWriteStreamMethod = getWriteStreamMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.WriteRequest, io.streamnative.oxia.proto.WriteResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "WriteStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.WriteRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.WriteResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("WriteStream"))
              .build();
        }
      }
    }
    return getWriteStreamMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ReadRequest,
      io.streamnative.oxia.proto.ReadResponse> getReadMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "Read",
      requestType = io.streamnative.oxia.proto.ReadRequest.class,
      responseType = io.streamnative.oxia.proto.ReadResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ReadRequest,
      io.streamnative.oxia.proto.ReadResponse> getReadMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ReadRequest, io.streamnative.oxia.proto.ReadResponse> getReadMethod;
    if ((getReadMethod = OxiaClientGrpc.getReadMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getReadMethod = OxiaClientGrpc.getReadMethod) == null) {
          OxiaClientGrpc.getReadMethod = getReadMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.ReadRequest, io.streamnative.oxia.proto.ReadResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "Read"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.ReadRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.ReadResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("Read"))
              .build();
        }
      }
    }
    return getReadMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ListRequest,
      io.streamnative.oxia.proto.ListResponse> getListMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "List",
      requestType = io.streamnative.oxia.proto.ListRequest.class,
      responseType = io.streamnative.oxia.proto.ListResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ListRequest,
      io.streamnative.oxia.proto.ListResponse> getListMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.ListRequest, io.streamnative.oxia.proto.ListResponse> getListMethod;
    if ((getListMethod = OxiaClientGrpc.getListMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getListMethod = OxiaClientGrpc.getListMethod) == null) {
          OxiaClientGrpc.getListMethod = getListMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.ListRequest, io.streamnative.oxia.proto.ListResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "List"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.ListRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.ListResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("List"))
              .build();
        }
      }
    }
    return getListMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.RangeScanRequest,
      io.streamnative.oxia.proto.RangeScanResponse> getRangeScanMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "RangeScan",
      requestType = io.streamnative.oxia.proto.RangeScanRequest.class,
      responseType = io.streamnative.oxia.proto.RangeScanResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.RangeScanRequest,
      io.streamnative.oxia.proto.RangeScanResponse> getRangeScanMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.RangeScanRequest, io.streamnative.oxia.proto.RangeScanResponse> getRangeScanMethod;
    if ((getRangeScanMethod = OxiaClientGrpc.getRangeScanMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getRangeScanMethod = OxiaClientGrpc.getRangeScanMethod) == null) {
          OxiaClientGrpc.getRangeScanMethod = getRangeScanMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.RangeScanRequest, io.streamnative.oxia.proto.RangeScanResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "RangeScan"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.RangeScanRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.RangeScanResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("RangeScan"))
              .build();
        }
      }
    }
    return getRangeScanMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.NotificationsRequest,
      io.streamnative.oxia.proto.NotificationBatch> getGetNotificationsMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "GetNotifications",
      requestType = io.streamnative.oxia.proto.NotificationsRequest.class,
      responseType = io.streamnative.oxia.proto.NotificationBatch.class,
      methodType = io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.NotificationsRequest,
      io.streamnative.oxia.proto.NotificationBatch> getGetNotificationsMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.NotificationsRequest, io.streamnative.oxia.proto.NotificationBatch> getGetNotificationsMethod;
    if ((getGetNotificationsMethod = OxiaClientGrpc.getGetNotificationsMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getGetNotificationsMethod = OxiaClientGrpc.getGetNotificationsMethod) == null) {
          OxiaClientGrpc.getGetNotificationsMethod = getGetNotificationsMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.NotificationsRequest, io.streamnative.oxia.proto.NotificationBatch>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.SERVER_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "GetNotifications"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.NotificationsRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.NotificationBatch.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("GetNotifications"))
              .build();
        }
      }
    }
    return getGetNotificationsMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.CreateSessionRequest,
      io.streamnative.oxia.proto.CreateSessionResponse> getCreateSessionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CreateSession",
      requestType = io.streamnative.oxia.proto.CreateSessionRequest.class,
      responseType = io.streamnative.oxia.proto.CreateSessionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.CreateSessionRequest,
      io.streamnative.oxia.proto.CreateSessionResponse> getCreateSessionMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.CreateSessionRequest, io.streamnative.oxia.proto.CreateSessionResponse> getCreateSessionMethod;
    if ((getCreateSessionMethod = OxiaClientGrpc.getCreateSessionMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getCreateSessionMethod = OxiaClientGrpc.getCreateSessionMethod) == null) {
          OxiaClientGrpc.getCreateSessionMethod = getCreateSessionMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.CreateSessionRequest, io.streamnative.oxia.proto.CreateSessionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CreateSession"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.CreateSessionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.CreateSessionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("CreateSession"))
              .build();
        }
      }
    }
    return getCreateSessionMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.SessionHeartbeat,
      io.streamnative.oxia.proto.KeepAliveResponse> getKeepAliveMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "KeepAlive",
      requestType = io.streamnative.oxia.proto.SessionHeartbeat.class,
      responseType = io.streamnative.oxia.proto.KeepAliveResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.SessionHeartbeat,
      io.streamnative.oxia.proto.KeepAliveResponse> getKeepAliveMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.SessionHeartbeat, io.streamnative.oxia.proto.KeepAliveResponse> getKeepAliveMethod;
    if ((getKeepAliveMethod = OxiaClientGrpc.getKeepAliveMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getKeepAliveMethod = OxiaClientGrpc.getKeepAliveMethod) == null) {
          OxiaClientGrpc.getKeepAliveMethod = getKeepAliveMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.SessionHeartbeat, io.streamnative.oxia.proto.KeepAliveResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "KeepAlive"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.SessionHeartbeat.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.KeepAliveResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("KeepAlive"))
              .build();
        }
      }
    }
    return getKeepAliveMethod;
  }

  private static volatile io.grpc.MethodDescriptor<io.streamnative.oxia.proto.CloseSessionRequest,
      io.streamnative.oxia.proto.CloseSessionResponse> getCloseSessionMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "CloseSession",
      requestType = io.streamnative.oxia.proto.CloseSessionRequest.class,
      responseType = io.streamnative.oxia.proto.CloseSessionResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<io.streamnative.oxia.proto.CloseSessionRequest,
      io.streamnative.oxia.proto.CloseSessionResponse> getCloseSessionMethod() {
    io.grpc.MethodDescriptor<io.streamnative.oxia.proto.CloseSessionRequest, io.streamnative.oxia.proto.CloseSessionResponse> getCloseSessionMethod;
    if ((getCloseSessionMethod = OxiaClientGrpc.getCloseSessionMethod) == null) {
      synchronized (OxiaClientGrpc.class) {
        if ((getCloseSessionMethod = OxiaClientGrpc.getCloseSessionMethod) == null) {
          OxiaClientGrpc.getCloseSessionMethod = getCloseSessionMethod =
              io.grpc.MethodDescriptor.<io.streamnative.oxia.proto.CloseSessionRequest, io.streamnative.oxia.proto.CloseSessionResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "CloseSession"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.CloseSessionRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  io.streamnative.oxia.proto.CloseSessionResponse.getDefaultInstance()))
              .setSchemaDescriptor(new OxiaClientMethodDescriptorSupplier("CloseSession"))
              .build();
        }
      }
    }
    return getCloseSessionMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static OxiaClientStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OxiaClientStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OxiaClientStub>() {
        @java.lang.Override
        public OxiaClientStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OxiaClientStub(channel, callOptions);
        }
      };
    return OxiaClientStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static OxiaClientBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OxiaClientBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OxiaClientBlockingStub>() {
        @java.lang.Override
        public OxiaClientBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OxiaClientBlockingStub(channel, callOptions);
        }
      };
    return OxiaClientBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static OxiaClientFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<OxiaClientFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<OxiaClientFutureStub>() {
        @java.lang.Override
        public OxiaClientFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new OxiaClientFutureStub(channel, callOptions);
        }
      };
    return OxiaClientFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * Oxia service that allows clients to discover shard-to-server assignments and
   * submit batches of requests.
   * Clients should connect to a random server to discover the shard-to-server
   * assignments and then send the actual batched requests to the appropriate
   * shard leader. In the future, this may be handled server-side in a proxy
   * layer to allows clients to not be concerned with sharding.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * Gets all shard-to-server assignments as a stream. Each set of assignments
     * in the response stream will contain all the assignments to bring the client
     * up to date. For example, if a shard is split, the stream will return a
     * single response containing all the new shard assignments as opposed to
     * multiple stream responses, each containing a single shard assignment.
     * Clients should connect to a single random server which will stream the
     * assignments for all shards on all servers.
     * </pre>
     */
    default void getShardAssignments(io.streamnative.oxia.proto.ShardAssignmentsRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ShardAssignments> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetShardAssignmentsMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Batches put, delete and delete_range requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * Deprecated
     * </pre>
     */
    default void write(io.streamnative.oxia.proto.WriteRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getWriteMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Batches put, delete and delete_range requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteRequest> writeStream(
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getWriteStreamMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Batches get requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * </pre>
     */
    default void read(io.streamnative.oxia.proto.ReadRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ReadResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getReadMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Requests all the keys between a range of keys.
     * Clients should send an equivalent request to all respective shards,
     * unless a particular partition key was specified.
     * </pre>
     */
    default void list(io.streamnative.oxia.proto.ListRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ListResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getListMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Requests all the records between a range of keys.
     * Clients should send an equivalent request to all respective shards,
     * unless a particular partition key was specified.
     * </pre>
     */
    default void rangeScan(io.streamnative.oxia.proto.RangeScanRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.RangeScanResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getRangeScanMethod(), responseObserver);
    }

    /**
     */
    default void getNotifications(io.streamnative.oxia.proto.NotificationsRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.NotificationBatch> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getGetNotificationsMethod(), responseObserver);
    }

    /**
     * <pre>
     * Creates a new client session. Sessions are kept alive by regularly sending
     * heartbeats via the KeepAlive rpc.
     * </pre>
     */
    default void createSession(io.streamnative.oxia.proto.CreateSessionRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CreateSessionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCreateSessionMethod(), responseObserver);
    }

    /**
     * <pre>
     * Sends a heartbeat to prevent the session from timing out.
     * </pre>
     */
    default void keepAlive(io.streamnative.oxia.proto.SessionHeartbeat request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.KeepAliveResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getKeepAliveMethod(), responseObserver);
    }

    /**
     * <pre>
     * Closes a session and removes all ephemeral values associated with it.
     * </pre>
     */
    default void closeSession(io.streamnative.oxia.proto.CloseSessionRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CloseSessionResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCloseSessionMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service OxiaClient.
   * <pre>
   **
   * Oxia service that allows clients to discover shard-to-server assignments and
   * submit batches of requests.
   * Clients should connect to a random server to discover the shard-to-server
   * assignments and then send the actual batched requests to the appropriate
   * shard leader. In the future, this may be handled server-side in a proxy
   * layer to allows clients to not be concerned with sharding.
   * </pre>
   */
  public static abstract class OxiaClientImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return OxiaClientGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service OxiaClient.
   * <pre>
   **
   * Oxia service that allows clients to discover shard-to-server assignments and
   * submit batches of requests.
   * Clients should connect to a random server to discover the shard-to-server
   * assignments and then send the actual batched requests to the appropriate
   * shard leader. In the future, this may be handled server-side in a proxy
   * layer to allows clients to not be concerned with sharding.
   * </pre>
   */
  public static final class OxiaClientStub
      extends io.grpc.stub.AbstractAsyncStub<OxiaClientStub> {
    private OxiaClientStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OxiaClientStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OxiaClientStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Gets all shard-to-server assignments as a stream. Each set of assignments
     * in the response stream will contain all the assignments to bring the client
     * up to date. For example, if a shard is split, the stream will return a
     * single response containing all the new shard assignments as opposed to
     * multiple stream responses, each containing a single shard assignment.
     * Clients should connect to a single random server which will stream the
     * assignments for all shards on all servers.
     * </pre>
     */
    public void getShardAssignments(io.streamnative.oxia.proto.ShardAssignmentsRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ShardAssignments> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getGetShardAssignmentsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Batches put, delete and delete_range requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * Deprecated
     * </pre>
     */
    public void write(io.streamnative.oxia.proto.WriteRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getWriteMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Batches put, delete and delete_range requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteRequest> writeStream(
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getWriteStreamMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     **
     * Batches get requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * </pre>
     */
    public void read(io.streamnative.oxia.proto.ReadRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ReadResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getReadMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Requests all the keys between a range of keys.
     * Clients should send an equivalent request to all respective shards,
     * unless a particular partition key was specified.
     * </pre>
     */
    public void list(io.streamnative.oxia.proto.ListRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ListResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getListMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * Requests all the records between a range of keys.
     * Clients should send an equivalent request to all respective shards,
     * unless a particular partition key was specified.
     * </pre>
     */
    public void rangeScan(io.streamnative.oxia.proto.RangeScanRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.RangeScanResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getRangeScanMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     */
    public void getNotifications(io.streamnative.oxia.proto.NotificationsRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.NotificationBatch> responseObserver) {
      io.grpc.stub.ClientCalls.asyncServerStreamingCall(
          getChannel().newCall(getGetNotificationsMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Creates a new client session. Sessions are kept alive by regularly sending
     * heartbeats via the KeepAlive rpc.
     * </pre>
     */
    public void createSession(io.streamnative.oxia.proto.CreateSessionRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CreateSessionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCreateSessionMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Sends a heartbeat to prevent the session from timing out.
     * </pre>
     */
    public void keepAlive(io.streamnative.oxia.proto.SessionHeartbeat request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.KeepAliveResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getKeepAliveMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     * Closes a session and removes all ephemeral values associated with it.
     * </pre>
     */
    public void closeSession(io.streamnative.oxia.proto.CloseSessionRequest request,
        io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CloseSessionResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCloseSessionMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service OxiaClient.
   * <pre>
   **
   * Oxia service that allows clients to discover shard-to-server assignments and
   * submit batches of requests.
   * Clients should connect to a random server to discover the shard-to-server
   * assignments and then send the actual batched requests to the appropriate
   * shard leader. In the future, this may be handled server-side in a proxy
   * layer to allows clients to not be concerned with sharding.
   * </pre>
   */
  public static final class OxiaClientBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<OxiaClientBlockingStub> {
    private OxiaClientBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OxiaClientBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OxiaClientBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Gets all shard-to-server assignments as a stream. Each set of assignments
     * in the response stream will contain all the assignments to bring the client
     * up to date. For example, if a shard is split, the stream will return a
     * single response containing all the new shard assignments as opposed to
     * multiple stream responses, each containing a single shard assignment.
     * Clients should connect to a single random server which will stream the
     * assignments for all shards on all servers.
     * </pre>
     */
    public java.util.Iterator<io.streamnative.oxia.proto.ShardAssignments> getShardAssignments(
        io.streamnative.oxia.proto.ShardAssignmentsRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getGetShardAssignmentsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Batches put, delete and delete_range requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * Deprecated
     * </pre>
     */
    public io.streamnative.oxia.proto.WriteResponse write(io.streamnative.oxia.proto.WriteRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getWriteMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Batches get requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * </pre>
     */
    public java.util.Iterator<io.streamnative.oxia.proto.ReadResponse> read(
        io.streamnative.oxia.proto.ReadRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getReadMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Requests all the keys between a range of keys.
     * Clients should send an equivalent request to all respective shards,
     * unless a particular partition key was specified.
     * </pre>
     */
    public java.util.Iterator<io.streamnative.oxia.proto.ListResponse> list(
        io.streamnative.oxia.proto.ListRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getListMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * Requests all the records between a range of keys.
     * Clients should send an equivalent request to all respective shards,
     * unless a particular partition key was specified.
     * </pre>
     */
    public java.util.Iterator<io.streamnative.oxia.proto.RangeScanResponse> rangeScan(
        io.streamnative.oxia.proto.RangeScanRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getRangeScanMethod(), getCallOptions(), request);
    }

    /**
     */
    public java.util.Iterator<io.streamnative.oxia.proto.NotificationBatch> getNotifications(
        io.streamnative.oxia.proto.NotificationsRequest request) {
      return io.grpc.stub.ClientCalls.blockingServerStreamingCall(
          getChannel(), getGetNotificationsMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Creates a new client session. Sessions are kept alive by regularly sending
     * heartbeats via the KeepAlive rpc.
     * </pre>
     */
    public io.streamnative.oxia.proto.CreateSessionResponse createSession(io.streamnative.oxia.proto.CreateSessionRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCreateSessionMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Sends a heartbeat to prevent the session from timing out.
     * </pre>
     */
    public io.streamnative.oxia.proto.KeepAliveResponse keepAlive(io.streamnative.oxia.proto.SessionHeartbeat request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getKeepAliveMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     * Closes a session and removes all ephemeral values associated with it.
     * </pre>
     */
    public io.streamnative.oxia.proto.CloseSessionResponse closeSession(io.streamnative.oxia.proto.CloseSessionRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCloseSessionMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service OxiaClient.
   * <pre>
   **
   * Oxia service that allows clients to discover shard-to-server assignments and
   * submit batches of requests.
   * Clients should connect to a random server to discover the shard-to-server
   * assignments and then send the actual batched requests to the appropriate
   * shard leader. In the future, this may be handled server-side in a proxy
   * layer to allows clients to not be concerned with sharding.
   * </pre>
   */
  public static final class OxiaClientFutureStub
      extends io.grpc.stub.AbstractFutureStub<OxiaClientFutureStub> {
    private OxiaClientFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected OxiaClientFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new OxiaClientFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Batches put, delete and delete_range requests.
     * Clients should send this request to the shard leader. In the future,
     * this may be handled server-side in a proxy layer.
     * Deprecated
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.streamnative.oxia.proto.WriteResponse> write(
        io.streamnative.oxia.proto.WriteRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getWriteMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Creates a new client session. Sessions are kept alive by regularly sending
     * heartbeats via the KeepAlive rpc.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.streamnative.oxia.proto.CreateSessionResponse> createSession(
        io.streamnative.oxia.proto.CreateSessionRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCreateSessionMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Sends a heartbeat to prevent the session from timing out.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.streamnative.oxia.proto.KeepAliveResponse> keepAlive(
        io.streamnative.oxia.proto.SessionHeartbeat request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getKeepAliveMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     * Closes a session and removes all ephemeral values associated with it.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<io.streamnative.oxia.proto.CloseSessionResponse> closeSession(
        io.streamnative.oxia.proto.CloseSessionRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCloseSessionMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_GET_SHARD_ASSIGNMENTS = 0;
  private static final int METHODID_WRITE = 1;
  private static final int METHODID_READ = 2;
  private static final int METHODID_LIST = 3;
  private static final int METHODID_RANGE_SCAN = 4;
  private static final int METHODID_GET_NOTIFICATIONS = 5;
  private static final int METHODID_CREATE_SESSION = 6;
  private static final int METHODID_KEEP_ALIVE = 7;
  private static final int METHODID_CLOSE_SESSION = 8;
  private static final int METHODID_WRITE_STREAM = 9;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_GET_SHARD_ASSIGNMENTS:
          serviceImpl.getShardAssignments((io.streamnative.oxia.proto.ShardAssignmentsRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ShardAssignments>) responseObserver);
          break;
        case METHODID_WRITE:
          serviceImpl.write((io.streamnative.oxia.proto.WriteRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse>) responseObserver);
          break;
        case METHODID_READ:
          serviceImpl.read((io.streamnative.oxia.proto.ReadRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ReadResponse>) responseObserver);
          break;
        case METHODID_LIST:
          serviceImpl.list((io.streamnative.oxia.proto.ListRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.ListResponse>) responseObserver);
          break;
        case METHODID_RANGE_SCAN:
          serviceImpl.rangeScan((io.streamnative.oxia.proto.RangeScanRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.RangeScanResponse>) responseObserver);
          break;
        case METHODID_GET_NOTIFICATIONS:
          serviceImpl.getNotifications((io.streamnative.oxia.proto.NotificationsRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.NotificationBatch>) responseObserver);
          break;
        case METHODID_CREATE_SESSION:
          serviceImpl.createSession((io.streamnative.oxia.proto.CreateSessionRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CreateSessionResponse>) responseObserver);
          break;
        case METHODID_KEEP_ALIVE:
          serviceImpl.keepAlive((io.streamnative.oxia.proto.SessionHeartbeat) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.KeepAliveResponse>) responseObserver);
          break;
        case METHODID_CLOSE_SESSION:
          serviceImpl.closeSession((io.streamnative.oxia.proto.CloseSessionRequest) request,
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.CloseSessionResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_WRITE_STREAM:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.writeStream(
              (io.grpc.stub.StreamObserver<io.streamnative.oxia.proto.WriteResponse>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getGetShardAssignmentsMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.ShardAssignmentsRequest,
              io.streamnative.oxia.proto.ShardAssignments>(
                service, METHODID_GET_SHARD_ASSIGNMENTS)))
        .addMethod(
          getWriteMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.WriteRequest,
              io.streamnative.oxia.proto.WriteResponse>(
                service, METHODID_WRITE)))
        .addMethod(
          getWriteStreamMethod(),
          io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.WriteRequest,
              io.streamnative.oxia.proto.WriteResponse>(
                service, METHODID_WRITE_STREAM)))
        .addMethod(
          getReadMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.ReadRequest,
              io.streamnative.oxia.proto.ReadResponse>(
                service, METHODID_READ)))
        .addMethod(
          getListMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.ListRequest,
              io.streamnative.oxia.proto.ListResponse>(
                service, METHODID_LIST)))
        .addMethod(
          getRangeScanMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.RangeScanRequest,
              io.streamnative.oxia.proto.RangeScanResponse>(
                service, METHODID_RANGE_SCAN)))
        .addMethod(
          getGetNotificationsMethod(),
          io.grpc.stub.ServerCalls.asyncServerStreamingCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.NotificationsRequest,
              io.streamnative.oxia.proto.NotificationBatch>(
                service, METHODID_GET_NOTIFICATIONS)))
        .addMethod(
          getCreateSessionMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.CreateSessionRequest,
              io.streamnative.oxia.proto.CreateSessionResponse>(
                service, METHODID_CREATE_SESSION)))
        .addMethod(
          getKeepAliveMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.SessionHeartbeat,
              io.streamnative.oxia.proto.KeepAliveResponse>(
                service, METHODID_KEEP_ALIVE)))
        .addMethod(
          getCloseSessionMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              io.streamnative.oxia.proto.CloseSessionRequest,
              io.streamnative.oxia.proto.CloseSessionResponse>(
                service, METHODID_CLOSE_SESSION)))
        .build();
  }

  private static abstract class OxiaClientBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    OxiaClientBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return io.streamnative.oxia.proto.Client.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("OxiaClient");
    }
  }

  private static final class OxiaClientFileDescriptorSupplier
      extends OxiaClientBaseDescriptorSupplier {
    OxiaClientFileDescriptorSupplier() {}
  }

  private static final class OxiaClientMethodDescriptorSupplier
      extends OxiaClientBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    OxiaClientMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (OxiaClientGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new OxiaClientFileDescriptorSupplier())
              .addMethod(getGetShardAssignmentsMethod())
              .addMethod(getWriteMethod())
              .addMethod(getWriteStreamMethod())
              .addMethod(getReadMethod())
              .addMethod(getListMethod())
              .addMethod(getRangeScanMethod())
              .addMethod(getGetNotificationsMethod())
              .addMethod(getCreateSessionMethod())
              .addMethod(getKeepAliveMethod())
              .addMethod(getCloseSessionMethod())
              .build();
        }
      }
    }
    return result;
  }
}
