/*
 * Copyright © 2022-2024 StreamNative Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.streamnative.oxia.client.grpc;

import java.util.Objects;
import lombok.NonNull;

/** Customised GRPC status code. */
public enum CustomStatusCode {
    ErrorNamespaceNotFound,
    // fallback to Status.code
    UNKNOWN;

    public static @NonNull CustomStatusCode fromDescription(String description) {
        Objects.requireNonNull(description);
        return switch (description) {
            case "oxia: namespace not found" -> ErrorNamespaceNotFound;
            default -> UNKNOWN;
        };
    }
}
