/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.shard;

import io.streamnative.oxia.client.shard.NoShardAvailableException;
import io.streamnative.oxia.client.shard.Shard;
import io.streamnative.oxia.client.shard.ShardManager;
import io.streamnative.oxia.client.shard.ShardStrategy;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;

public class ShardAssignmentsContainer {
    private final ConcurrentMap<Long, Shard> shards = new ConcurrentHashMap<Long, Shard>();
    private final ShardStrategy shardStrategy;
    private final String namespace;

    ShardAssignmentsContainer(ShardStrategy shardStrategy, String namespace) {
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty");
        }
        this.shardStrategy = shardStrategy;
        this.namespace = namespace;
    }

    public long getShardForKey(String key) {
        Predicate<Shard> test = this.shardStrategy.acceptsKeyPredicate(key);
        Optional<Shard> shard = this.shards.values().stream().filter(test).findFirst();
        if (shard.isPresent()) {
            return shard.get().id();
        }
        throw new NoShardAvailableException(key);
    }

    public String leader(long shardId) {
        Shard shard = (Shard)this.shards.get(shardId);
        if (shard == null) {
            throw new NoShardAvailableException(shardId);
        }
        return shard.leader();
    }

    void update(ShardManager.ShardAssignmentChanges changes) {
        changes.added().forEach(s2 -> this.shards.put(s2.id(), (Shard)s2));
        changes.reassigned().forEach(s2 -> this.shards.put(s2.id(), (Shard)s2));
        changes.removed().forEach(s2 -> this.shards.remove(s2.id(), s2));
    }

    Set<Long> allShardIds() {
        return this.shards.keySet();
    }

    Map<Long, Shard> allShards() {
        return this.shards;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

