/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.shard;

import io.streamnative.oxia.client.shard.HashRange;
import io.streamnative.oxia.proto.ShardAssignment;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public record Shard(long id, @NonNull String leader, @NonNull HashRange hashRange) {
    public Shard(long id, @NonNull String leader, @NonNull HashRange hashRange) {
        if (leader == null) {
            throw new NullPointerException("leader is marked non-null but is null");
        }
        if (hashRange == null) {
            throw new NullPointerException("hashRange is marked non-null but is null");
        }
    }

    public boolean overlaps(@NonNull Shard other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return this.hashRange.overlaps(other.hashRange);
    }

    @NonNull
    public Set<Shard> findOverlapping(@NonNull Collection<Shard> other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return other.stream().filter(o -> !this.equals(o)).filter(this::overlaps).collect(Collectors.toSet());
    }

    @NonNull
    static Shard fromProto(@NonNull ShardAssignment s2) {
        if (s2 == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        return new Shard(s2.getShardId(), s2.getLeader(), HashRange.fromProto(s2.getInt32HashRange()));
    }
}

