/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.batch.Batch;
import io.streamnative.oxia.client.batch.BatchBase;
import io.streamnative.oxia.client.batch.Operation;
import io.streamnative.oxia.client.batch.ReadBatchFactory;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.proto.GetResponse;
import io.streamnative.oxia.proto.ReadRequest;
import io.streamnative.oxia.proto.ReadResponse;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

final class ReadBatch
extends BatchBase
implements Batch,
StreamObserver<ReadResponse> {
    private final ReadBatchFactory factory;
    @VisibleForTesting
    final List<Operation.ReadOperation.GetOperation> gets = new ArrayList<Operation.ReadOperation.GetOperation>();
    private int responseIndex = 0;
    long startSendTimeNanos;

    ReadBatch(ReadBatchFactory factory, OxiaStubProvider stubProvider, long shardId) {
        super(stubProvider, shardId);
        this.factory = factory;
    }

    @Override
    public boolean canAdd(@NonNull Operation<?> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        return true;
    }

    @Override
    public void add(@NonNull Operation<?> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (operation instanceof Operation.ReadOperation.GetOperation) {
            Operation.ReadOperation.GetOperation g2 = (Operation.ReadOperation.GetOperation)operation;
            this.gets.add(g2);
        }
    }

    @Override
    public int size() {
        return this.gets.size();
    }

    @Override
    public void send() {
        this.startSendTimeNanos = System.nanoTime();
        try {
            this.getStub().async().read(this.toProto(), this);
        }
        catch (Throwable t2) {
            this.onError(t2);
        }
    }

    @Override
    public void onNext(ReadResponse response) {
        for (int i = 0; i < response.getGetsCount(); ++i) {
            GetResponse gr = response.getGets(i);
            this.gets.get(this.responseIndex).complete(gr);
            ++this.responseIndex;
        }
    }

    @Override
    public void onError(Throwable batchError) {
        this.gets.forEach(g2 -> g2.fail(batchError));
        this.factory.getReadRequestLatencyHistogram().recordFailure(System.nanoTime() - this.startSendTimeNanos);
    }

    @Override
    public void onCompleted() {
        this.factory.getReadRequestLatencyHistogram().recordSuccess(System.nanoTime() - this.startSendTimeNanos);
    }

    @NonNull
    ReadRequest toProto() {
        return ReadRequest.newBuilder().setShardId(this.getShardId()).addAllGets(this.gets.stream().map(Operation.ReadOperation.GetOperation::toProto).collect(Collectors.toList())).build();
    }
}

