/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.batch.Batch;
import io.streamnative.oxia.client.batch.BatchFactory;
import io.streamnative.oxia.client.batch.Operation;
import io.streamnative.oxia.client.batch.ReadBatchFactory;
import io.streamnative.oxia.client.batch.WriteBatchFactory;
import io.streamnative.oxia.client.grpc.OxiaStubProvider;
import io.streamnative.oxia.client.metrics.InstrumentProvider;
import io.streamnative.oxia.client.session.SessionManager;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.NonNull;

public class Batcher
implements AutoCloseable {
    private static final int DEFAULT_INITIAL_QUEUE_CAPACITY = 1000;
    @NonNull
    private final ClientConfig config;
    private final long shardId;
    @NonNull
    private final BatchFactory batchFactory;
    @NonNull
    private final BlockingQueue<Operation<?>> operations;
    private final Thread thread;

    Batcher(@NonNull ClientConfig config, long shardId, @NonNull BatchFactory batchFactory) {
        this(config, shardId, batchFactory, new ArrayBlockingQueue(1000));
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (batchFactory == null) {
            throw new NullPointerException("batchFactory is marked non-null but is null");
        }
    }

    Batcher(@NonNull ClientConfig config, long shardId, @NonNull BatchFactory batchFactory, @NonNull BlockingQueue<Operation<?>> operations) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (batchFactory == null) {
            throw new NullPointerException("batchFactory is marked non-null but is null");
        }
        if (operations == null) {
            throw new NullPointerException("operations is marked non-null but is null");
        }
        this.config = config;
        this.shardId = shardId;
        this.batchFactory = batchFactory;
        this.operations = operations;
        this.thread = new DefaultThreadFactory(String.format("batcher-shard-%d", shardId)).newThread(this::batcherLoop);
        this.thread.start();
    }

    public <R> void add(@NonNull Operation<R> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        try {
            this.operations.put(operation);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void batcherLoop() {
        Batch batch = null;
        long lingerBudgetNanos = -1L;
        while (true) {
            Operation<?> operation;
            try {
                if (batch == null) {
                    operation = this.operations.take();
                } else {
                    operation = this.operations.poll(lingerBudgetNanos, TimeUnit.NANOSECONDS);
                    long spentLingerBudgetNanos = Math.max(0L, System.nanoTime() - batch.getStartTimeNanos());
                    lingerBudgetNanos = Math.max(0L, lingerBudgetNanos - spentLingerBudgetNanos);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            if (operation != null) {
                if (batch == null) {
                    batch = this.batchFactory.getBatch(this.shardId);
                    lingerBudgetNanos = this.config.batchLinger().toNanos();
                }
                try {
                    if (!batch.canAdd(operation)) {
                        batch.send();
                        batch = this.batchFactory.getBatch(this.shardId);
                        lingerBudgetNanos = this.config.batchLinger().toNanos();
                    }
                    batch.add(operation);
                }
                catch (Exception e) {
                    operation.fail(e);
                }
            }
            if (batch == null || batch.size() != this.config.maxRequestsPerBatch() && lingerBudgetNanos != 0L) continue;
            batch.send();
            batch = null;
        }
    }

    @NonNull
    static Function<Long, Batcher> newReadBatcherFactory(@NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, InstrumentProvider instrumentProvider) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        return s2 -> new Batcher(config, (long)s2, new ReadBatchFactory(stubProvider, config, instrumentProvider));
    }

    @NonNull
    static Function<Long, Batcher> newWriteBatcherFactory(@NonNull ClientConfig config, @NonNull OxiaStubProvider stubProvider, @NonNull SessionManager sessionManager, InstrumentProvider instrumentProvider) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubProvider == null) {
            throw new NullPointerException("stubProvider is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        return s2 -> new Batcher(config, (long)s2, new WriteBatchFactory(stubProvider, sessionManager, config, instrumentProvider));
    }

    @Override
    public void close() {
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

