/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import io.opentelemetry.api.OpenTelemetry;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.SyncOxiaClient;
import io.streamnative.oxia.client.api.exceptions.OxiaException;
import io.streamnative.oxia.client.internal.DefaultImplementation;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface OxiaClientBuilder {
    public static OxiaClientBuilder create(String serviceAddress) {
        return DefaultImplementation.getDefaultImplementation(serviceAddress);
    }

    public SyncOxiaClient syncClient() throws OxiaException;

    public CompletableFuture<AsyncOxiaClient> asyncClient();

    public OxiaClientBuilder requestTimeout(Duration var1);

    public OxiaClientBuilder batchLinger(Duration var1);

    public OxiaClientBuilder maxRequestsPerBatch(int var1);

    public OxiaClientBuilder recordCacheCapacity(int var1);

    public OxiaClientBuilder namespace(String var1);

    public OxiaClientBuilder disableRecordCache();

    public OxiaClientBuilder sessionTimeout(Duration var1);

    public OxiaClientBuilder clientIdentifier(String var1);

    public OxiaClientBuilder clientIdentifier(Supplier<String> var1);

    public OxiaClientBuilder openTelemetry(OpenTelemetry var1);
}

