/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.Version;
import io.streamnative.oxia.proto.GetResponse;
import io.streamnative.oxia.proto.PutResponse;
import java.util.Optional;
import lombok.NonNull;

public final class ProtoUtil {
    public static long uint32ToLong(int n) {
        if (n >= 0) {
            return n;
        }
        return 0x80000000L + (long)(n & Integer.MAX_VALUE);
    }

    @NonNull
    public static PutResult getPutResultFromProto(@NonNull PutResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        return new PutResult(ProtoUtil.getVersionFromProto(response.getVersion()));
    }

    @NonNull
    public static GetResult getResultFromProto(@NonNull GetResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        return new GetResult(response.getValue().toByteArray(), ProtoUtil.getVersionFromProto(response.getVersion()));
    }

    @NonNull
    public static Version getVersionFromProto(@NonNull io.streamnative.oxia.proto.Version version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return new Version(version.getVersionId(), version.getCreatedTimestamp(), version.getModifiedTimestamp(), version.getModificationsCount(), version.hasSessionId() ? Optional.of(version.getSessionId()) : Optional.empty(), version.hasClientIdentity() ? Optional.of(version.getClientIdentity()) : Optional.empty());
    }

    private ProtoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

