/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.streamnative.oxia.client.AsyncOxiaClientImpl;
import io.streamnative.oxia.client.CachingAsyncOxiaClient;
import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.SyncOxiaClientImpl;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.OxiaClientBuilder;
import io.streamnative.oxia.client.api.SyncOxiaClient;
import io.streamnative.oxia.client.api.exceptions.OxiaException;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Strings;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import lombok.NonNull;

public class OxiaClientBuilderImpl
implements OxiaClientBuilder {
    public static final Duration DefaultBatchLinger = Duration.ofMillis(5L);
    public static final int DefaultMaxRequestsPerBatch = 1000;
    public static final int DefaultMaxBatchSize = 131072;
    public static final Duration DefaultRequestTimeout = Duration.ofSeconds(30L);
    public static final Duration DefaultSessionTimeout = Duration.ofSeconds(15L);
    public static final int DefaultRecordCacheCapacity = 0;
    public static final String DefaultNamespace = "default";
    @NonNull
    private final String serviceAddress;
    @NonNull
    private Duration requestTimeout = DefaultRequestTimeout;
    @NonNull
    private Duration batchLinger = DefaultBatchLinger;
    private int maxRequestsPerBatch = 1000;
    private int recordCacheCapacity = 0;
    @NonNull
    private Duration sessionTimeout = DefaultSessionTimeout;
    @NonNull
    private Supplier<String> clientIdentifier = OxiaClientBuilderImpl::randomClientIdentifier;
    @NonNull
    private String namespace = "default";
    @NonNull
    private OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();

    @Override
    @NonNull
    public OxiaClientBuilder requestTimeout(@NonNull Duration requestTimeout) {
        if (requestTimeout == null) {
            throw new NullPointerException("requestTimeout is marked non-null but is null");
        }
        if (requestTimeout.isNegative() || requestTimeout.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("requestTimeout must be greater than zero: " + requestTimeout);
        }
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder batchLinger(@NonNull Duration batchLinger) {
        if (batchLinger == null) {
            throw new NullPointerException("batchLinger is marked non-null but is null");
        }
        if (batchLinger.isNegative() || batchLinger.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("batchLinger must be greater than zero: " + batchLinger);
        }
        this.batchLinger = batchLinger;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder maxRequestsPerBatch(int maxRequestsPerBatch) {
        if (maxRequestsPerBatch <= 0) {
            throw new IllegalArgumentException("MaxRequestsPerBatch must be greater than zero: " + maxRequestsPerBatch);
        }
        this.maxRequestsPerBatch = maxRequestsPerBatch;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder recordCacheCapacity(int recordCacheCapacity) {
        if (recordCacheCapacity <= 0) {
            throw new IllegalArgumentException("recordCacheCapacity must be greater than zero: " + recordCacheCapacity);
        }
        this.recordCacheCapacity = recordCacheCapacity;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder namespace(@NonNull String namespace) {
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        if (Strings.isNullOrEmpty(namespace)) {
            throw new IllegalArgumentException("namespace must not be null or empty.");
        }
        this.namespace = namespace;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder disableRecordCache() {
        this.recordCacheCapacity = 0;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder sessionTimeout(@NonNull Duration sessionTimeout) {
        if (sessionTimeout == null) {
            throw new NullPointerException("sessionTimeout is marked non-null but is null");
        }
        if (sessionTimeout.isNegative() || sessionTimeout.equals(Duration.ZERO)) {
            throw new IllegalArgumentException("SessionTimeout must be greater than zero: " + sessionTimeout);
        }
        this.sessionTimeout = sessionTimeout;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder clientIdentifier(@NonNull String clientIdentifier) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        this.clientIdentifier = () -> clientIdentifier;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder clientIdentifier(@NonNull Supplier<String> clientIdentifier) {
        if (clientIdentifier == null) {
            throw new NullPointerException("clientIdentifier is marked non-null but is null");
        }
        this.clientIdentifier = clientIdentifier;
        return this;
    }

    @Override
    @NonNull
    public OxiaClientBuilder openTelemetry(@NonNull OpenTelemetry openTelemetry) {
        if (openTelemetry == null) {
            throw new NullPointerException("openTelemetry is marked non-null but is null");
        }
        this.openTelemetry = openTelemetry;
        return this;
    }

    @Override
    @NonNull
    public CompletableFuture<AsyncOxiaClient> asyncClient() {
        ClientConfig config = new ClientConfig(this.serviceAddress, this.requestTimeout, this.batchLinger, this.maxRequestsPerBatch, 131072, this.recordCacheCapacity, this.sessionTimeout, this.clientIdentifier.get(), this.openTelemetry, this.namespace);
        CompletableFuture<AsyncOxiaClient> async = AsyncOxiaClientImpl.newInstance(config);
        if (config.recordCacheCapacity() > 0) {
            return async.thenApply(a -> new CachingAsyncOxiaClient(config, (AsyncOxiaClient)a));
        }
        return async;
    }

    @Override
    public SyncOxiaClient syncClient() throws OxiaException {
        return new SyncOxiaClientImpl(this.asyncClient().join());
    }

    @NonNull
    private static String randomClientIdentifier() {
        return "oxia-client-java:" + UUID.randomUUID();
    }

    public OxiaClientBuilderImpl(@NonNull String serviceAddress) {
        if (serviceAddress == null) {
            throw new NullPointerException("serviceAddress is marked non-null but is null");
        }
        this.serviceAddress = serviceAddress;
    }
}

