/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.common;

import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import io.streamnative.pulsarmetadatastoreoxia.shaded.javax.annotation.concurrent.Immutable;
import java.util.List;

@Immutable
public interface AttributeKey<T> {
    public String getKey();

    public AttributeType getType();

    public static AttributeKey<String> stringKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.STRING);
    }

    public static AttributeKey<Boolean> booleanKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.BOOLEAN);
    }

    public static AttributeKey<Long> longKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.LONG);
    }

    public static AttributeKey<Double> doubleKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.DOUBLE);
    }

    public static AttributeKey<List<String>> stringArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.STRING_ARRAY);
    }

    public static AttributeKey<List<Boolean>> booleanArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.BOOLEAN_ARRAY);
    }

    public static AttributeKey<List<Long>> longArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.LONG_ARRAY);
    }

    public static AttributeKey<List<Double>> doubleArrayKey(String key) {
        return InternalAttributeKeyImpl.create(key, AttributeType.DOUBLE_ARRAY);
    }
}

