/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal;

import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Preconditions;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Stopwatch;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.InternalServiceProviders;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.NameResolver;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.NameResolverProvider;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.BackoffPolicyRetryScheduler;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.DnsNameResolver;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.ExponentialBackoffPolicy;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.GrpcUtil;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.internal.RetryingNameResolver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new RetryingNameResolver(new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader())), new BackoffPolicyRetryScheduler(new ExponentialBackoffPolicy.Provider(), args.getScheduledExecutorService(), args.getSynchronizationContext()), args.getSynchronizationContext());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

