/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsarmetadatastoreoxia.shaded.com.salesforce.reactivegrpc.common;

import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Preconditions;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.salesforce.reactivegrpc.common.AbstractUnimplementedQueue;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.salesforce.reactivegrpc.common.Consumer;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.stub.CallStreamObserver;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.stub.StreamObserver;
import io.streamnative.pulsarmetadatastoreoxia.shaded.org.reactivestreams.Publisher;
import io.streamnative.pulsarmetadatastoreoxia.shaded.org.reactivestreams.Subscriber;
import io.streamnative.pulsarmetadatastoreoxia.shaded.org.reactivestreams.Subscription;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;

public abstract class AbstractStreamObserverAndPublisher<T>
extends AbstractUnimplementedQueue<T>
implements Publisher<T>,
StreamObserver<T>,
Subscription,
Queue<T> {
    private static final Subscription EMPTY_SUBSCRIPTION = new Subscription(){

        @Override
        public void cancel() {
        }

        @Override
        public void request(long n) {
        }
    };
    public static final int DEFAULT_CHUNK_SIZE = 512;
    public static final int TWO_THIRDS_OF_DEFAULT_CHUNK_SIZE = 341;
    private static final int UNSUBSCRIBED_STATE = 0;
    private static final int SUBSCRIBED_ONCE_STATE = 1;
    private static final int PREFETCHED_ONCE_STATE = 2;
    private static final int SPIN_LOCK_PARK_NANOS = 10;
    protected volatile boolean outputFused;
    private final Queue<T> queue;
    private final int prefetch;
    private final int limit;
    private final Consumer<CallStreamObserver<?>> onSubscribe;
    private volatile boolean done;
    private Throwable error;
    protected volatile Subscriber<? super T> downstream;
    private volatile boolean cancelled;
    protected volatile CallStreamObserver<?> subscription;
    private static final AtomicReferenceFieldUpdater<AbstractStreamObserverAndPublisher, CallStreamObserver> SUBSCRIPTION = AtomicReferenceFieldUpdater.newUpdater(AbstractStreamObserverAndPublisher.class, CallStreamObserver.class, "subscription");
    private volatile Runnable onTerminate;
    private static final AtomicReferenceFieldUpdater<AbstractStreamObserverAndPublisher, Runnable> ON_TERMINATE = AtomicReferenceFieldUpdater.newUpdater(AbstractStreamObserverAndPublisher.class, Runnable.class, "onTerminate");
    private volatile int state;
    private static final AtomicIntegerFieldUpdater<AbstractStreamObserverAndPublisher> STATE = AtomicIntegerFieldUpdater.newUpdater(AbstractStreamObserverAndPublisher.class, "state");
    private volatile int wip;
    private static final AtomicIntegerFieldUpdater<AbstractStreamObserverAndPublisher> WIP = AtomicIntegerFieldUpdater.newUpdater(AbstractStreamObserverAndPublisher.class, "wip");
    private volatile long requested;
    private static final AtomicLongFieldUpdater<AbstractStreamObserverAndPublisher> REQUESTED = AtomicLongFieldUpdater.newUpdater(AbstractStreamObserverAndPublisher.class, "requested");
    private int produced;

    AbstractStreamObserverAndPublisher(Queue<T> queue, Consumer<CallStreamObserver<?>> onSubscribe) {
        this(queue, 512, 341, onSubscribe);
    }

    AbstractStreamObserverAndPublisher(Queue<T> queue, Consumer<CallStreamObserver<?>> onSubscribe, Runnable onTerminate) {
        this(queue, 512, 341, onSubscribe, onTerminate);
    }

    AbstractStreamObserverAndPublisher(Queue<T> queue, int prefetch, int lowTide, Consumer<CallStreamObserver<?>> onSubscribe) {
        this(queue, prefetch, lowTide, onSubscribe, null);
    }

    AbstractStreamObserverAndPublisher(Queue<T> queue, int prefetch, int lowTide, Consumer<CallStreamObserver<?>> onSubscribe, Runnable onTerminate) {
        this.prefetch = prefetch;
        this.limit = lowTide;
        this.queue = queue;
        this.onSubscribe = onSubscribe;
        this.onTerminate = onTerminate;
    }

    protected void onSubscribe(CallStreamObserver<?> upstream) {
        if (this.subscription == null && SUBSCRIPTION.compareAndSet(this, null, upstream)) {
            upstream.disableAutoInboundFlowControl();
            if (this.onSubscribe != null) {
                this.onSubscribe.accept(upstream);
            }
            return;
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " supports only a single subscription");
    }

    private void doTerminate() {
        Runnable r = this.onTerminate;
        if (r != null && ON_TERMINATE.compareAndSet(this, r, null)) {
            r.run();
        }
    }

    private void drainRegular(Subscriber<? super T> subscriber) {
        int missed = 1;
        CallStreamObserver<?> s2 = this.subscription;
        Queue<T> q = this.queue;
        int sent = this.produced;
        while (true) {
            long r = this.requested;
            while (r != (long)sent) {
                boolean empty;
                boolean d = this.done;
                T t2 = q.poll();
                boolean bl = empty = t2 == null;
                if (this.checkTerminated(d, empty, subscriber, q)) {
                    return;
                }
                if (empty) break;
                subscriber.onNext(t2);
                if (++sent != this.limit) continue;
                if (r != Long.MAX_VALUE) {
                    r = REQUESTED.addAndGet(this, -sent);
                }
                s2.request(sent);
                sent = 0;
            }
            if (r == (long)sent && this.checkTerminated(this.done, q.isEmpty(), subscriber, q)) {
                return;
            }
            int w = this.wip;
            if (missed == w) {
                this.produced = sent;
                if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                break;
            }
            missed = w;
        }
    }

    private void drainFused(Subscriber<? super T> subscriber) {
        int missed = 1;
        do {
            if (this.cancelled) {
                this.discardQueue(this.queue);
                this.downstream = null;
                return;
            }
            boolean d = this.done;
            subscriber.onNext(null);
            if (!d) continue;
            this.downstream = null;
            Throwable ex = this.error;
            if (ex != null) {
                subscriber.onError(ex);
            } else {
                subscriber.onComplete();
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    private void drain() {
        if (WIP.getAndIncrement(this) != 0) {
            return;
        }
        int missed = 1;
        do {
            Subscriber<? super T> subscriber;
            if ((subscriber = this.downstream) == null) continue;
            if (this.outputFused) {
                this.drainFused(subscriber);
            } else {
                this.drainRegular(subscriber);
            }
            return;
        } while ((missed = WIP.addAndGet(this, -missed)) != 0);
    }

    private boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> subscriber, Queue<T> q) {
        if (this.cancelled) {
            this.discardQueue(q);
            this.downstream = null;
            return true;
        }
        if (d && empty) {
            Throwable e = this.error;
            this.downstream = null;
            if (e != null) {
                subscriber.onError(e);
            } else {
                subscriber.onComplete();
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNext(T t2) {
        if (this.done || this.cancelled) {
            this.discardElement(t2);
            return;
        }
        while (!this.queue.offer(t2)) {
            LockSupport.parkNanos(10L);
        }
        this.drain();
    }

    @Override
    public void onError(Throwable t2) {
        if (this.done || this.cancelled) {
            return;
        }
        this.error = t2;
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void onCompleted() {
        if (this.done || this.cancelled) {
            return;
        }
        this.done = true;
        this.doTerminate();
        this.drain();
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        Preconditions.checkNotNull(actual);
        if (this.state == 0 && STATE.compareAndSet(this, 0, 1)) {
            actual.onSubscribe(this);
            this.downstream = actual;
            if (this.cancelled) {
                this.downstream = null;
            } else {
                this.drain();
            }
        } else {
            actual.onSubscribe(EMPTY_SUBSCRIPTION);
            actual.onError(new IllegalStateException(this.getClass().getSimpleName() + " allows only a single Subscriber"));
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void request(long n) {
        if (n > 0L) {
            AbstractStreamObserverAndPublisher.addCap(REQUESTED, this, n);
            if (this.state == 1 && STATE.compareAndSet(this, 1, 2)) {
                this.subscription.request(this.prefetch);
            }
            this.drain();
        }
    }

    private static <T> long addCap(AtomicLongFieldUpdater<T> updater, T instance, long toAdd) {
        long u;
        long r;
        do {
            if ((r = updater.get(instance)) == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            u = r + toAdd;
            if (u >= 0L) continue;
            u = Long.MAX_VALUE;
        } while (!updater.compareAndSet(instance, r, u));
        return r;
    }

    @Override
    public void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.doOnCancel();
        this.doTerminate();
        if (!this.outputFused && WIP.getAndIncrement(this) == 0) {
            this.discardQueue(this.queue);
            this.downstream = null;
        }
    }

    protected void doOnCancel() {
    }

    @Override
    public T poll() {
        T v = this.queue.poll();
        if (v != null) {
            int p = this.produced + 1;
            if (p == this.limit) {
                this.produced = 0;
                this.subscription.request(p);
            } else {
                this.produced = p;
            }
        }
        return v;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    protected void discardQueue(Queue<T> q) {
        q.clear();
    }

    protected void discardElement(T t2) {
    }
}

