/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.shard;

import io.streamnative.oxia.client.CompositeConsumer;
import io.streamnative.oxia.client.grpc.CustomStatusCode;
import io.streamnative.oxia.client.grpc.GrpcResponseStream;
import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.metrics.ShardAssignmentMetrics;
import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.oxia.client.shard.HashRangeShardStrategy;
import io.streamnative.oxia.client.shard.NamespaceNotFoundException;
import io.streamnative.oxia.client.shard.NoShardAvailableException;
import io.streamnative.oxia.client.shard.Shard;
import io.streamnative.oxia.client.shard.ShardStrategy;
import io.streamnative.oxia.proto.NamespaceShardsAssignment;
import io.streamnative.oxia.proto.ShardAssignments;
import io.streamnative.oxia.proto.ShardAssignmentsRequest;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.common.base.Strings;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.Status;
import io.streamnative.pulsarmetadatastoreoxia.shaded.io.grpc.StatusRuntimeException;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.Disposable;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.ConnectableFlux;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Flux;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Mono;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.scheduler.Scheduler;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.scheduler.Schedulers;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.retry.Retry;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.util.retry.RetryBackoffSpec;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardManager
extends GrpcResponseStream
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ShardManager.class);
    @NonNull
    private final Assignments assignments;
    @NonNull
    private final CompositeConsumer<ShardAssignmentChanges> callbacks;
    @NonNull
    private final ShardAssignmentMetrics metrics;
    private final Scheduler scheduler;

    @VisibleForTesting
    ShardManager(@NonNull OxiaStub stub, @NonNull Assignments assignments, @NonNull CompositeConsumer<ShardAssignmentChanges> callbacks, @NonNull ShardAssignmentMetrics metrics) {
        super(stub);
        if (stub == null) {
            throw new NullPointerException("stub is marked non-null but is null");
        }
        if (assignments == null) {
            throw new NullPointerException("assignments is marked non-null but is null");
        }
        if (callbacks == null) {
            throw new NullPointerException("callbacks is marked non-null but is null");
        }
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        this.assignments = assignments;
        this.callbacks = callbacks;
        this.metrics = metrics;
        this.scheduler = Schedulers.newSingle("shard-assignments");
    }

    public ShardManager(@NonNull OxiaStub stub, @NonNull Metrics metrics, @NonNull String namespace) {
        this(stub, new Assignments(HashRangeShardStrategy.Xxh332HashRangeShardStrategy, namespace), new CompositeConsumer<ShardAssignmentChanges>(), ShardAssignmentMetrics.create(metrics));
        if (stub == null) {
            throw new NullPointerException("stub is marked non-null but is null");
        }
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
    }

    @Override
    public void close() {
        super.close();
        this.scheduler.dispose();
    }

    @Override
    protected CompletableFuture<Void> start(OxiaStub stub, Consumer<Disposable> consumer) {
        RetryBackoffSpec retrySpec = Retry.backoff(Long.MAX_VALUE, Duration.ofMillis(100L)).filter(this::isErrorRetryable).doBeforeRetry(signal -> log.warn("Retrying receiving shard assignments: {}", signal));
        ConnectableFlux<ShardAssignments> assignmentsFlux = Flux.defer(() -> stub.reactor().getShardAssignments(ShardAssignmentsRequest.newBuilder().setNamespace(this.assignments.namespace).build())).doOnError(this::processError).retryWhen(retrySpec).repeat().publishOn(this.scheduler).doOnNext(this::updateAssignments).doOnEach(this.metrics::recordAssignments).publish();
        CompletableFuture<Void> future = Mono.from(assignmentsFlux).then().toFuture();
        Disposable disposable = assignmentsFlux.connect();
        consumer.accept(disposable);
        return future;
    }

    private void processError(@NonNull Throwable error) {
        CustomStatusCode customStatusCode;
        String description;
        StatusRuntimeException statusError;
        Status status;
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        if (error instanceof StatusRuntimeException && (status = (statusError = (StatusRuntimeException)error).getStatus()).getCode() == Status.Code.UNKNOWN && (description = status.getDescription()) != null && (customStatusCode = CustomStatusCode.fromDescription(description)) == CustomStatusCode.ErrorNamespaceNotFound) {
            NamespaceNotFoundException ex = new NamespaceNotFoundException(this.assignments.namespace);
            log.error("Failed receiving shard assignments", ex);
            throw ex;
        }
        log.warn("Failed receiving shard assignments", error);
    }

    private void updateAssignments(ShardAssignments shardAssignments) {
        NamespaceShardsAssignment nsSharedAssignments = shardAssignments.getNamespacesMap().get(this.assignments.namespace);
        if (nsSharedAssignments == null) {
            throw new NamespaceNotFoundException(this.assignments.namespace, true);
        }
        List<Shard> updates = nsSharedAssignments.getAssignmentsList().stream().map(Shard::fromProto).collect(Collectors.toList());
        Map<Long, Shard> updatedMap = ShardManager.recomputeShardHashBoundaries(this.assignments.shards, updates);
        ShardAssignmentChanges changes = ShardManager.computeShardLeaderChanges(this.assignments.shards, updatedMap);
        this.assignments.update(updates);
        this.callbacks.accept(changes);
        this.metrics.recordChanges(changes);
    }

    @VisibleForTesting
    static Map<Long, Shard> recomputeShardHashBoundaries(Map<Long, Shard> assignments, List<Shard> updates) {
        ArrayList toDelete = new ArrayList();
        updates.forEach(update -> update.findOverlapping(assignments.values()).forEach(existing -> {
            log.info("Deleting shard {} as it overlaps with {}", existing, update);
            toDelete.add(existing.id());
        }));
        return Collections.unmodifiableMap(Stream.concat(assignments.entrySet().stream().filter(e -> !toDelete.contains(e.getKey())).map(Map.Entry::getValue), updates.stream()).collect(Collectors.toMap(Shard::id, Function.identity())));
    }

    @VisibleForTesting
    static ShardAssignmentChanges computeShardLeaderChanges(Map<Long, Shard> oldAssignments, Map<Long, Shard> newAssignments) {
        Set removed = oldAssignments.entrySet().stream().filter(e -> !newAssignments.containsKey(e.getKey())).map(e -> new ShardAssignmentChange.Removed((Long)e.getKey(), ((Shard)e.getValue()).leader())).collect(Collectors.toSet());
        Set added = newAssignments.entrySet().stream().filter(e -> !oldAssignments.containsKey(e.getKey())).map(e -> new ShardAssignmentChange.Added((Long)e.getKey(), ((Shard)e.getValue()).leader())).collect(Collectors.toSet());
        Set changed = oldAssignments.entrySet().stream().filter(e -> newAssignments.containsKey(e.getKey())).filter(e -> !((Shard)newAssignments.get(e.getKey())).leader().equals(((Shard)e.getValue()).leader())).map(e -> {
            Long shardId = (Long)e.getKey();
            String oldLeader = ((Shard)e.getValue()).leader();
            String newLeader = ((Shard)newAssignments.get(e.getKey())).leader();
            return new ShardAssignmentChange.Reassigned(shardId, oldLeader, newLeader);
        }).collect(Collectors.toSet());
        return new ShardAssignmentChanges(Collections.unmodifiableSet(added), Collections.unmodifiableSet(removed), Collections.unmodifiableSet(changed));
    }

    public long get(String key) {
        return this.assignments.get(key);
    }

    public List<Long> getAll() {
        return this.assignments.getAll();
    }

    public String leader(long shardId) {
        return this.assignments.leader(shardId);
    }

    public void addCallback(@NonNull Consumer<ShardAssignmentChanges> callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.callbacks.add(callback);
    }

    private boolean isErrorRetryable(@NonNull Throwable ex) {
        if (ex == null) {
            throw new NullPointerException("ex is marked non-null but is null");
        }
        if (ex instanceof NamespaceNotFoundException) {
            NamespaceNotFoundException nsNotFoundError = (NamespaceNotFoundException)ex;
            return nsNotFoundError.isRetryable();
        }
        return true;
    }

    public static class Assignments {
        private final Lock rLock;
        private final Lock wLock;
        private Map<Long, Shard> shards = new HashMap<Long, Shard>();
        private final ShardStrategy shardStrategy;
        private final String namespace;

        Assignments(ShardStrategy shardStrategy, String namespace) {
            this(new ReentrantReadWriteLock(), shardStrategy, namespace);
        }

        Assignments(ReadWriteLock lock, ShardStrategy shardStrategy, String namespace) {
            if (Strings.isNullOrEmpty(namespace)) {
                throw new IllegalArgumentException("namespace must not be null or empty");
            }
            this.shardStrategy = shardStrategy;
            this.namespace = namespace;
            this.rLock = lock.readLock();
            this.wLock = lock.writeLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long get(String key) {
            try {
                this.rLock.lock();
                Predicate<Shard> test = this.shardStrategy.acceptsKeyPredicate(key);
                Optional<Shard> shard = this.shards.values().stream().filter(test).findAny();
                long l = shard.map(Shard::id).orElseThrow(() -> new NoShardAvailableException(key));
                return l;
            }
            finally {
                this.rLock.unlock();
            }
        }

        public List<Long> getAll() {
            try {
                this.rLock.lock();
                List<Long> list = this.shards.keySet().stream().toList();
                return list;
            }
            finally {
                this.rLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String leader(long shardId) {
            try {
                this.rLock.lock();
                String string = Optional.ofNullable(this.shards.get(shardId)).map(Shard::leader).orElseThrow(() -> new NoShardAvailableException(shardId));
                return string;
            }
            finally {
                this.rLock.unlock();
            }
        }

        void update(List<Shard> updates) {
            try {
                this.wLock.lock();
                this.shards = ShardManager.recomputeShardHashBoundaries(this.shards, updates);
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    public record ShardAssignmentChanges(Set<ShardAssignmentChange.Added> added, Set<ShardAssignmentChange.Removed> removed, Set<ShardAssignmentChange.Reassigned> reassigned) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ShardAssignmentChange {

        public record Reassigned(long shardId, @NonNull String fromLeader, @NonNull String toLeader) implements ShardAssignmentChange
        {
            public Reassigned(long shardId, @NonNull String fromLeader, @NonNull String toLeader) {
                if (fromLeader == null) {
                    throw new NullPointerException("fromLeader is marked non-null but is null");
                }
                if (toLeader == null) {
                    throw new NullPointerException("toLeader is marked non-null but is null");
                }
            }
        }

        public record Removed(long shardId, @NonNull String leader) implements ShardAssignmentChange
        {
            public Removed(long shardId, @NonNull String leader) {
                if (leader == null) {
                    throw new NullPointerException("leader is marked non-null but is null");
                }
            }
        }

        public record Added(long shardId, @NonNull String leader) implements ShardAssignmentChange
        {
            public Added(long shardId, @NonNull String leader) {
                if (leader == null) {
                    throw new NullPointerException("leader is marked non-null but is null");
                }
            }
        }
    }
}

