/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics;

import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.oxia.client.shard.ShardManager;
import io.streamnative.oxia.proto.ShardAssignments;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Signal;
import java.util.Map;
import lombok.NonNull;

public class ShardAssignmentMetrics {
    @NonNull
    private final Metrics.Histogram event;
    @NonNull
    private final Metrics.Histogram change;

    @NonNull
    public static ShardAssignmentMetrics create(@NonNull Metrics metrics) {
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        Metrics.Histogram event = metrics.histogram("oxia_client_shard_assignment", Metrics.Unit.NONE);
        Metrics.Histogram change = metrics.histogram("oxia_client_shard_assignment_change", Metrics.Unit.NONE);
        return new ShardAssignmentMetrics(event, change);
    }

    public void recordAssignments(@NonNull Signal<ShardAssignments> signal) {
        if (signal == null) {
            throw new NullPointerException("signal is marked non-null but is null");
        }
        String type = "event";
        switch (signal.getType()) {
            case ON_NEXT: {
                this.event.record(1L, Metrics.attributes(type, true));
                break;
            }
            case ON_ERROR: {
                this.event.record(1L, Metrics.attributes(type, false));
                break;
            }
        }
    }

    public void recordChanges(@NonNull ShardManager.ShardAssignmentChanges changes) {
        if (changes == null) {
            throw new NullPointerException("changes is marked non-null but is null");
        }
        this.change.record(changes.added().size(), Map.of("type", "added"));
        this.change.record(changes.removed().size(), Map.of("type", "removed"));
        this.change.record(changes.reassigned().size(), Map.of("type", "reassigned"));
    }

    ShardAssignmentMetrics(@NonNull Metrics.Histogram event, @NonNull Metrics.Histogram change) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (change == null) {
            throw new NullPointerException("change is marked non-null but is null");
        }
        this.event = event;
        this.change = change;
    }
}

