/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics;

import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.oxia.proto.KeepAliveResponse;
import io.streamnative.pulsarmetadatastoreoxia.shaded.reactor.core.publisher.Signal;
import lombok.NonNull;

public class SessionMetrics {
    @NonNull
    private final Metrics.Histogram keepalive;

    @NonNull
    public static SessionMetrics create(@NonNull Metrics metrics) {
        if (metrics == null) {
            throw new NullPointerException("metrics is marked non-null but is null");
        }
        Metrics.Histogram heartbeat = metrics.histogram("oxia_client_session_keepalive", Metrics.Unit.NONE);
        return new SessionMetrics(heartbeat);
    }

    public void recordKeepAlive(@NonNull Signal<KeepAliveResponse> signal) {
        if (signal == null) {
            throw new NullPointerException("signal is marked non-null but is null");
        }
        String type = "heartbeat";
        switch (signal.getType()) {
            case ON_NEXT: {
                this.keepalive.record(1L, Metrics.attributes(type, true));
                break;
            }
            case ON_ERROR: {
                this.keepalive.record(1L, Metrics.attributes(type, false));
                break;
            }
        }
    }

    SessionMetrics(@NonNull Metrics.Histogram keepalive) {
        if (keepalive == null) {
            throw new NullPointerException("keepalive is marked non-null but is null");
        }
        this.keepalive = keepalive;
    }
}

