/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics;

import io.streamnative.oxia.client.metrics.api.Metrics;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.github.benmanes.caffeine.cache.RemovalCause;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.streamnative.pulsarmetadatastoreoxia.shaded.org.checkerframework.checker.index.qual.NonNegative;
import java.util.HashMap;
import java.util.Map;

public class CacheMetrics
implements StatsCounter {
    private final Metrics.Histogram loadTimer;
    private final Metrics.Histogram hits;
    private final Metrics.Histogram evictions;

    public static CacheMetrics create(Metrics metrics) {
        Metrics.Histogram loadTimer = metrics.histogram("oxia_client_cache_load_timer", Metrics.Unit.MILLISECONDS);
        Metrics.Histogram hits = metrics.histogram("oxia_client_cache_hits", Metrics.Unit.NONE);
        Metrics.Histogram evictions = metrics.histogram("oxia_client_cache_evictions", Metrics.Unit.NONE);
        return new CacheMetrics(loadTimer, hits, evictions);
    }

    @Override
    public void recordHits(@NonNegative int count) {
        this.hits.record(count, Metrics.attributes("hit", true));
    }

    @Override
    public void recordMisses(@NonNegative int count) {
        this.hits.record(count, Metrics.attributes("hit", false));
    }

    @Override
    public void recordLoadSuccess(@NonNegative long loadTime) {
        this.loadTimer.record(loadTime, Metrics.attributes("load", true));
    }

    @Override
    public void recordLoadFailure(@NonNegative long loadTime) {
        this.loadTimer.record(loadTime, Metrics.attributes("load", false));
    }

    @Override
    public void recordEviction(@NonNegative int weight, RemovalCause removalCause) {
        HashMap<String, String> attributes = new HashMap<String, String>(Metrics.attributes("eviction"));
        attributes.put("removal_cause", removalCause == null ? "unknown" : removalCause.name().toLowerCase());
        this.evictions.record(weight, Map.copyOf(attributes));
    }

    @Override
    public CacheStats snapshot() {
        throw new UnsupportedOperationException("Metrics should be observed via the Oxia client metrics subsystem");
    }

    CacheMetrics(Metrics.Histogram loadTimer, Metrics.Histogram hits, Metrics.Histogram evictions) {
        this.loadTimer = loadTimer;
        this.hits = hits;
        this.evictions = evictions;
    }
}

