/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.metrics;

import io.streamnative.oxia.client.metrics.api.Metrics;
import java.time.Clock;
import java.util.Map;

public class BatchMetrics {
    private final Clock clock;
    private final Metrics.Histogram timerTotal;
    private final Metrics.Histogram timerExec;
    private final Metrics.Histogram size;
    private final Metrics.Histogram count;

    public static BatchMetrics create(Clock clock, Metrics metrics) {
        Metrics.Histogram timerTotal = metrics.histogram("oxia_client_batch_total_timer", Metrics.Unit.MILLISECONDS);
        Metrics.Histogram timerExec = metrics.histogram("oxia_client_batch_exec_timer", Metrics.Unit.MILLISECONDS);
        Metrics.Histogram size = metrics.histogram("oxia_client_batch_size", Metrics.Unit.BYTES);
        Metrics.Histogram count = metrics.histogram("oxia_client_batch_requests", Metrics.Unit.NONE);
        return new BatchMetrics(clock, timerTotal, timerExec, size, count);
    }

    public Sample recordWrite() {
        return new Sample("write", this.clock, this.timerTotal, this.timerExec, this.size, this.count, this.clock.millis());
    }

    public Sample recordRead() {
        return new Sample("read", this.clock, this.timerTotal, this.timerExec, this.size, this.count, this.clock.millis());
    }

    BatchMetrics(Clock clock, Metrics.Histogram timerTotal, Metrics.Histogram timerExec, Metrics.Histogram size, Metrics.Histogram count) {
        this.clock = clock;
        this.timerTotal = timerTotal;
        this.timerExec = timerExec;
        this.size = size;
        this.count = count;
    }

    public static class Sample {
        private final String type;
        private final Clock clock;
        private final Metrics.Histogram timerTotal;
        private final Metrics.Histogram timerExec;
        private final Metrics.Histogram size;
        private final Metrics.Histogram count;
        private final long startTotal;
        private long startExec;

        public void startExec() {
            this.startExec = this.clock.millis();
        }

        public void stop(Throwable t2, long size, long count) {
            Map<String, String> attributes = Metrics.attributes(this.type, t2);
            long end = this.clock.millis();
            this.timerTotal.record(end - this.startTotal, attributes);
            this.timerExec.record(end - this.startExec, attributes);
            this.size.record(size, attributes);
            this.count.record(count, attributes);
        }

        Sample(String type, Clock clock, Metrics.Histogram timerTotal, Metrics.Histogram timerExec, Metrics.Histogram size, Metrics.Histogram count, long startTotal) {
            this.type = type;
            this.clock = clock;
            this.timerTotal = timerTotal;
            this.timerExec = timerExec;
            this.size = size;
            this.count = count;
            this.startTotal = startTotal;
        }
    }
}

