/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.KeyAlreadyExistsException;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.SessionDoesNotExistException;
import io.streamnative.oxia.client.api.UnexpectedVersionIdException;
import io.streamnative.oxia.proto.DeleteRangeRequest;
import io.streamnative.oxia.proto.DeleteRangeResponse;
import io.streamnative.oxia.proto.DeleteRequest;
import io.streamnative.oxia.proto.DeleteResponse;
import io.streamnative.oxia.proto.GetRequest;
import io.streamnative.oxia.proto.GetResponse;
import io.streamnative.oxia.proto.PutRequest;
import io.streamnative.oxia.proto.PutResponse;
import io.streamnative.oxia.proto.Status;
import io.streamnative.pulsarmetadatastoreoxia.shaded.com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Operation<R> {
    public static final Comparator<Operation> PriorityComparator = (o1, o2) -> {
        if (o1 == CloseOperation.INSTANCE) {
            return -1;
        }
        if (o2 == CloseOperation.INSTANCE) {
            return 1;
        }
        return Long.compare(o1.sequence(), o2.sequence());
    };

    public CompletableFuture<R> callback();

    public long sequence();

    default public void fail(Throwable t2) {
        this.callback().completeExceptionally(t2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum CloseOperation implements Operation<Void>
    {
        INSTANCE{

            @Override
            public long sequence() {
                return Long.MIN_VALUE;
            }
        };


        @Override
        public CompletableFuture<Void> callback() {
            return null;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface WriteOperation<R>
    extends Operation<R> {

        public record DeleteRangeOperation(long sequence, @NonNull CompletableFuture<Void> callback, @NonNull String startKeyInclusive, @NonNull String endKeyExclusive) implements WriteOperation<Void>
        {
            public DeleteRangeOperation(long sequence, @NonNull CompletableFuture<Void> callback, @NonNull String startKeyInclusive, @NonNull String endKeyExclusive) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (startKeyInclusive == null) {
                    throw new NullPointerException("startKeyInclusive is marked non-null but is null");
                }
                if (endKeyExclusive == null) {
                    throw new NullPointerException("endKeyExclusive is marked non-null but is null");
                }
            }

            DeleteRangeRequest toProto() {
                return DeleteRangeRequest.newBuilder().setStartInclusive(this.startKeyInclusive).setEndExclusive(this.endKeyExclusive).build();
            }

            void complete(@NonNull DeleteRangeResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                if (response.getStatus() == Status.OK) {
                    this.callback.complete(null);
                } else {
                    this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                }
            }
        }

        public record DeleteOperation(long sequence, @NonNull CompletableFuture<Boolean> callback, @NonNull String key, @NonNull Optional<Long> expectedVersionId) implements WriteOperation<Boolean>
        {
            public DeleteOperation(long sequence, @NonNull CompletableFuture<Boolean> callback, @NonNull String key, @NonNull Optional<Long> expectedVersionId) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                if (expectedVersionId == null) {
                    throw new NullPointerException("expectedVersionId is marked non-null but is null");
                }
                if (expectedVersionId.isPresent() && expectedVersionId.get() < 0L) {
                    throw new IllegalArgumentException("expectedVersionId must be >= 0, was: " + expectedVersionId.get());
                }
            }

            public DeleteOperation(long sequence, @NonNull CompletableFuture<Boolean> callback, @NonNull String key) {
                this(sequence, callback, key, Optional.empty());
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
            }

            DeleteRequest toProto() {
                DeleteRequest.Builder builder = DeleteRequest.newBuilder().setKey(this.key);
                this.expectedVersionId.ifPresent(builder::setExpectedVersionId);
                return builder.build();
            }

            void complete(@NonNull DeleteResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                switch (response.getStatus()) {
                    case UNEXPECTED_VERSION_ID: {
                        this.fail(new UnexpectedVersionIdException(this.key, this.expectedVersionId.get()));
                        break;
                    }
                    case KEY_NOT_FOUND: {
                        this.callback.complete(false);
                        break;
                    }
                    case OK: {
                        this.callback.complete(true);
                        break;
                    }
                    default: {
                        this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                    }
                }
            }
        }

        public record PutOperation(long sequence, @NonNull CompletableFuture<PutResult> callback, @NonNull String key, byte @NonNull [] value, @NonNull Optional<Long> expectedVersionId, boolean ephemeral) implements WriteOperation<PutResult>
        {
            public PutOperation(long sequence, @NonNull CompletableFuture<PutResult> callback, @NonNull String key, byte[] value, @NonNull Optional<Long> expectedVersionId, boolean ephemeral) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                if (expectedVersionId == null) {
                    throw new NullPointerException("expectedVersionId is marked non-null but is null");
                }
                if (expectedVersionId.isPresent() && expectedVersionId.get() < -1L) {
                    throw new IllegalArgumentException("expectedVersionId must be >= -1 (KeyNotExists), was: " + expectedVersionId.get());
                }
            }

            PutRequest toProto(@NonNull Optional<SessionInfo> sessionInfo) {
                if (sessionInfo == null) {
                    throw new NullPointerException("sessionInfo is marked non-null but is null");
                }
                PutRequest.Builder builder = PutRequest.newBuilder().setKey(this.key).setValue(ByteString.copyFrom(this.value));
                this.expectedVersionId.ifPresent(builder::setExpectedVersionId);
                if (this.ephemeral) {
                    if (sessionInfo.isPresent()) {
                        builder.setSessionId(sessionInfo.get().sessionId()).setClientIdentity(sessionInfo.get().clientIdentifier());
                    } else {
                        throw new IllegalStateException("session context required for ephemeral operation");
                    }
                }
                return builder.build();
            }

            void complete(@NonNull PutResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                switch (response.getStatus()) {
                    case SESSION_DOES_NOT_EXIST: {
                        this.fail(new SessionDoesNotExistException());
                        break;
                    }
                    case UNEXPECTED_VERSION_ID: {
                        if (this.expectedVersionId.get() == -1L) {
                            this.fail(new KeyAlreadyExistsException(this.key));
                            break;
                        }
                        this.fail(new UnexpectedVersionIdException(this.key, this.expectedVersionId.get()));
                        break;
                    }
                    case OK: {
                        this.callback.complete(PutResult.fromProto(response));
                        break;
                    }
                    default: {
                        this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                    }
                }
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PutOperation that = (PutOperation)o;
                return this.key.equals(that.key) && Arrays.equals(this.value, that.value) && Objects.equals(this.expectedVersionId, that.expectedVersionId);
            }

            @Override
            public int hashCode() {
                int result = Objects.hash(this.key, this.expectedVersionId);
                result = 31 * result + Arrays.hashCode(this.value);
                return result;
            }

            record SessionInfo(long sessionId, @NonNull String clientIdentifier) {
                public SessionInfo(long sessionId, @NonNull String clientIdentifier) {
                    if (clientIdentifier == null) {
                        throw new NullPointerException("clientIdentifier is marked non-null but is null");
                    }
                }
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ReadOperation<R>
    extends Operation<R> {

        public record GetOperation(long sequence, @NonNull CompletableFuture<GetResult> callback, @NonNull String key) implements ReadOperation<GetResult>
        {
            public GetOperation(long sequence, @NonNull CompletableFuture<GetResult> callback, @NonNull String key) {
                if (callback == null) {
                    throw new NullPointerException("callback is marked non-null but is null");
                }
                if (key == null) {
                    throw new NullPointerException("key is marked non-null but is null");
                }
            }

            GetRequest toProto() {
                return GetRequest.newBuilder().setKey(this.key).setIncludeValue(true).build();
            }

            void complete(@NonNull GetResponse response) {
                if (response == null) {
                    throw new NullPointerException("response is marked non-null but is null");
                }
                switch (response.getStatus()) {
                    case KEY_NOT_FOUND: {
                        this.callback.complete(null);
                        break;
                    }
                    case OK: {
                        this.callback.complete(GetResult.fromProto(response));
                        break;
                    }
                    default: {
                        this.fail(new IllegalStateException("GRPC.Status: " + response.getStatus().name()));
                    }
                }
            }
        }
    }
}

