/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.streamnative.oxia.client.ClientConfig;
import io.streamnative.oxia.client.batch.Batcher;
import io.streamnative.oxia.client.grpc.OxiaStub;
import io.streamnative.oxia.client.metrics.BatchMetrics;
import io.streamnative.oxia.client.session.SessionManager;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class BatchManager
implements AutoCloseable {
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final ConcurrentMap<Long, Batcher> batchersByShardId = new ConcurrentHashMap<Long, Batcher>();
    @NonNull
    private final Function<Long, Batcher> batcherFactory;
    private volatile boolean closed;

    public Batcher getBatcher(long shardId) {
        if (this.closed) {
            throw new IllegalStateException("Batch manager is closed");
        }
        return this.batchersByShardId.computeIfAbsent(shardId, this::createAndStartBatcher);
    }

    private Batcher createAndStartBatcher(long shardId) {
        Batcher batcher = this.batcherFactory.apply(shardId);
        this.executor.execute(batcher);
        return batcher;
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        List<Exception> exceptions = this.batchersByShardId.values().stream().map(b -> {
            try {
                b.close();
                return null;
            }
            catch (Exception e) {
                return e;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.shutdownExecutor();
        if (!exceptions.isEmpty()) {
            throw new ShutdownException(exceptions);
        }
    }

    private void shutdownExecutor() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
        }
    }

    @NonNull
    public static BatchManager newReadBatchManager(@NonNull ClientConfig config, @NonNull Function<Long, OxiaStub> stubByShardId, BatchMetrics metrics) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubByShardId == null) {
            throw new NullPointerException("stubByShardId is marked non-null but is null");
        }
        return new BatchManager(Batcher.newReadBatcherFactory(config, stubByShardId, Clock.systemUTC(), metrics));
    }

    @NonNull
    public static BatchManager newWriteBatchManager(@NonNull ClientConfig config, @NonNull Function<Long, OxiaStub> stubByShardId, @NonNull SessionManager sessionManager, BatchMetrics metrics) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (stubByShardId == null) {
            throw new NullPointerException("stubByShardId is marked non-null but is null");
        }
        if (sessionManager == null) {
            throw new NullPointerException("sessionManager is marked non-null but is null");
        }
        return new BatchManager(Batcher.newWriteBatcherFactory(config, stubByShardId, sessionManager, Clock.systemUTC(), metrics));
    }

    public BatchManager(@NonNull Function<Long, Batcher> batcherFactory) {
        if (batcherFactory == null) {
            throw new NullPointerException("batcherFactory is marked non-null but is null");
        }
        this.batcherFactory = batcherFactory;
    }

    public static class ShutdownException
    extends Exception {
        @NonNull
        private final List<Exception> exceptions;

        ShutdownException(@NonNull List<Exception> exceptions) {
            if (exceptions == null) {
                throw new NullPointerException("exceptions is marked non-null but is null");
            }
            this.exceptions = exceptions;
        }

        @NonNull
        public List<Exception> getExceptions() {
            return this.exceptions;
        }
    }
}

