/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface PutOption {
    public static final VersionIdPutOption IfRecordDoesNotExist = new VersionIdPutOption.IfRecordDoesNotExist();
    public static final VersionIdPutOption Unconditionally = new VersionIdPutOption.Unconditionally();
    public static final PutOption AsEphemeralRecord = new AsEphemeralRecord();

    default public boolean cannotCoExistWith(PutOption option) {
        return false;
    }

    public static VersionIdPutOption ifVersionIdEquals(long versionId) {
        return new VersionIdPutOption.IfVersionIdEquals(versionId);
    }

    public static Set<PutOption> validate(PutOption ... args) {
        if (args == null || args.length == 0) {
            return Set.of(Unconditionally);
        }
        Arrays.stream(args).forEach(a -> {
            if (Arrays.stream(args).filter(c -> !c.equals(a)).anyMatch(c -> a.cannotCoExistWith((PutOption)c))) {
                throw new IllegalArgumentException("Incompatible " + PutOption.class.getSimpleName() + "s: " + Arrays.toString(args));
            }
        });
        return new HashSet<PutOption>(Arrays.asList(args));
    }

    public static Optional<Long> toVersionId(Collection<PutOption> options) {
        return options.stream().filter(o -> o instanceof VersionIdPutOption).findAny().map(o -> ((VersionIdPutOption)o).toVersionId());
    }

    public static boolean toEphemeral(Collection<PutOption> options) {
        return options.stream().anyMatch(o -> o instanceof AsEphemeralRecord);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface VersionIdPutOption
    extends PutOption {
        public Long toVersionId();

        @Override
        default public boolean cannotCoExistWith(PutOption option) {
            return option instanceof VersionIdPutOption;
        }

        public record Unconditionally() implements VersionIdPutOption
        {
            @Override
            public Long toVersionId() {
                return null;
            }
        }

        public record IfRecordDoesNotExist() implements VersionIdPutOption
        {
            @Override
            public Long toVersionId() {
                return -1L;
            }
        }

        public record IfVersionIdEquals(long versionId) implements VersionIdPutOption
        {
            public IfVersionIdEquals {
                if (versionId < 0L) {
                    throw new IllegalArgumentException("versionId cannot be less than 0 - was: " + versionId);
                }
            }

            @Override
            public Long toVersionId() {
                return this.versionId();
            }
        }
    }

    public record AsEphemeralRecord() implements PutOption
    {
    }
}

